﻿using Microsoft.AspNetCore.Hosting;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Farakonesh.API.Filters;
using Farakonesh.Logic.IDatabase.IUser;
using Farakonesh.Logic.IDatabase;
using Farakonesh.Models.Database.StoredProcedures.App.User;
using System.Threading.Tasks;
using Farakonesh.Models.Database.StoredProcedures.App.User.Company;
using Farakonesh.Logic.Services.App.User;
using Farakonesh.Logic.IDatabase.idbo;
using Microsoft.AspNetCore.Identity;
using Farakonesh.Logic.IServices.IApp.IUser;
using Farakonesh.Commands.Services;
using System.Threading;

namespace Farakonesh.API.Controllers.App.User
{
    /// <summary>
    /// کار با سرویس های مجموعه های همکار
    /// </summary>
    [Route("api/[controller]/[action]")]
    [ApiController]
    public class CompanyController : ControllerBase
    {
        private readonly ICompanyContext _ctx;
        private readonly IUserServices _userServices;
        public CompanyController(ICompanyContext ctx,IUserServices userServices)
        {
            _ctx = ctx;
            _userServices = userServices;
        }
        /// <summary>
        /// دریافت اطلاعات کمپانی فرد لاگین شده
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        [CompanyAuth]
        public async Task<IActionResult> Get([FromBody] GetCompany.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.GetCompany(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// دریافت اطلاعات کامل و مورد نیاز کاربر لاگین شده به پنل کمپانی
        /// </summary>
        /// <param name="command"></param>
        /// <returns></returns>
        [HttpPut]
        [CompanyAuth]
        public async Task<IActionResult> GetFull([FromBody] GetFullCompanyCommand command, CancellationToken cancellationToken)
        {
            var rst = await _userServices.getFullCompany(command, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// دریافت لیست کمپانی های فرد لاگین شده
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        [CompanyAuth]
        public async Task<IActionResult> GetAllByUserId([FromBody] GetCompanyListByUserId.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.GetCompanyListByUserId(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// دریافت لیست کمپانی ها
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> GetAll([FromBody] GetCompanyList.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.GetCompanyList(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// دریافت کمپانی با شناسه
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> GetById([FromBody] GetCompanyById.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.GetCompanyById(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// افزودن یک کمپانی جدید
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPost]
        public async Task<IActionResult> Save([FromBody] Insert_Company.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Insert_Company(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// بروز رسانی کمپانی
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> Update([FromBody] Update_Company.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Update_Company(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// حذف کمپانی
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpDelete]
        public async Task<IActionResult> Delete([FromQuery] Delete_Company.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Delete_Company(inputs, cancellationToken);
            return Ok(rst);
        }
    }
}
