﻿using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Farakonesh.API.Filters;
using Farakonesh.Commands.Services.Order;
using Farakonesh.Logic.IDatabase.IUser;
using Farakonesh.Logic.IServices.IApp.IUser;
using Farakonesh.Models.Database.StoredProcedures.App.User.Company;
using Farakonesh.Models.Database.StoredProcedures.App.User.Discount;
using System.Threading;
using System.Threading.Tasks;

namespace Farakonesh.API.Controllers.App.User
{
    /// <summary>
    /// سرویس های کار با کد تخفیف توسط کمپانی
    /// </summary>
    [Route("api/[controller]/[action]")]
    [ApiController]
    [CompanyAuth]
    public class CompanyDiscountController : ControllerBase
    {
        private readonly IDiscountContext _ctx;
        private readonly IUserServices _userServices;
        public CompanyDiscountController(IDiscountContext ctx, IUserServices userServices)
        {
            _ctx = ctx;
            _userServices = userServices;
        }


        /// <summary>
        /// کد های تخفیف کمپانی
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [CompanyAuth]
        [HttpPut]
        public async Task<IActionResult> Get([FromBody] GetDiscountByCompany.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.GetDiscountByCompany(inputs, cancellationToken);
            return Ok(rst);
        }

        /// <summary>
        /// حذف  کد تخفیف توسط کمپانی
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [CompanyAuth]
        [HttpDelete]
        public async Task<IActionResult> Delete([FromQuery] Delete_DiscountByCompany.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Delete_DiscountByCompany(inputs, cancellationToken);
            return Ok(rst);
        }

        /// <summary>
        /// تولید کد تخفیف توسط کمپانی
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [CompanyAuth]
        [HttpPost]
        public async Task<IActionResult> Save([FromBody] Insert_DiscountByCompany.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Insert_DiscountByCompany(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// ارسال پیامک کد تخفیف به مشتری توسط کمپانی
        /// </summary>
        /// <param name="command"></param>
        /// <returns></returns>
        [CompanyAuth]
        [HttpPut]
        public async Task<IActionResult> SendAlarmDiscountCode([FromBody] GetDiscountForAlarmByCompanyCommand command, CancellationToken cancellationToken)
        {
            var rst = await _userServices.sendAlarmDiscountCodeByCompany(command, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// بروز رسانی کد تخفیف توسط کمپانی
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [CompanyAuth]
        [HttpPut]
        public async Task<IActionResult> Update([FromBody] Update_DiscountByCompany.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Update_DiscountByCompany(inputs, cancellationToken);
            return Ok(rst);
        }
    }
}
