﻿using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Farakonesh.API.Filters;
using Farakonesh.Logic.IDatabase.IUser;
using Farakonesh.Models.Database.StoredProcedures.App.User.Company;
using Farakonesh.Models.Database.StoredProcedures.App.User.Discount;
using System.Threading;
using System.Threading.Tasks;

namespace Farakonesh.API.Controllers.App.User
{
    [Route("api/[controller]/[action]")]
    [ApiController]
    [CompanyAuth]
    public class CompanyDiscountUserController : ControllerBase
    {
        private readonly IDiscountContext _ctx;
        public CompanyDiscountUserController(IDiscountContext ctx)
        {
            _ctx = ctx;
        }
        /// <summary>
        /// دریافت کاربرانی که کد تخفیف را دریافت کرده اند
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        [CompanyAuth]
        public async Task<IActionResult> Get([FromBody] GetDiscountUserByCompany.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.GetDiscountUserByCompany(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// انتصاب کد تخفیف به کاربران کمپانی
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPost]
        [CompanyAuth]
        public async Task<IActionResult> Save([FromBody] Insert_Discount_UserByCompany.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Insert_Discount_UserByCompany(inputs, cancellationToken);
            return Ok(rst);
        }

        /// <summary>
        /// حذف انتصاب کد تخفیف از کاربر توسط کمپانی
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpDelete]
        [CompanyAuth]
        public async Task<IActionResult> Delete([FromQuery] Delete_Discount_UserByCompany.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Delete_Discount_UserByCompany(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// حذف انتصاب کد تخفیف از کاربر توسط ادمین
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpDelete]
        public async Task<IActionResult> DeleteByAdmin([FromQuery] Delete_Discount_UserByAdmin.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Delete_Discount_UserByAdmin(inputs, cancellationToken);
            return Ok(rst);
        }
    }
}
