﻿using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Farakonesh.Logic.IDatabase.IUser;
using Farakonesh.Models.Database.StoredProcedures.App.User.Company;
using System.Threading;
using System.Threading.Tasks;

namespace Farakonesh.API.Controllers.App.User
{
    /// <summary>
    /// سرویس های کار با انتصاب کاربر و کمپانی
    /// </summary>
    [Route("api/[controller]/[action]")]
    [ApiController]
    public class CompanyUserController : ControllerBase
    {
        private readonly ICompanyContext _ctx;
        public CompanyUserController(ICompanyContext ctx)
        {
            _ctx = ctx;
        }
        /// <summary>
        /// دریافت لیست کمپانی ها به همراه کاربران
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> GetAll([FromBody] Get_Company_User.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Get_Company_User(inputs, cancellationToken);
            return Ok(rst);
        }

        /// <summary>
        /// انتصاب یک کاربر به یک کمپانی
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPost]
        public async Task<IActionResult> Save([FromBody] Insert_Company_User.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Insert_Company_User(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// بروز رسانی انتصاب یک کاربر به یک کمپانی
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> Update([FromBody] Update_Company_User.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Update_Company_User(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// حذف انتصاب یک کاربر از یک کمپانی
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpDelete]
        public async Task<IActionResult> Delete([FromQuery] Delete_Company_User.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Delete_Company_User(inputs, cancellationToken);
            return Ok(rst);
        }
    }
}
