﻿using Microsoft.AspNetCore.Hosting;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Farakonesh.API.Filters;
using Farakonesh.Logic.IDatabase.IUser;
using Farakonesh.Logic.IDatabase;
using System.Threading.Tasks;
using Farakonesh.Models.Database.StoredProcedures.App.User.Discount;
using System.Threading;

namespace Farakonesh.API.Controllers.App.User
{
    /// <summary>
    /// سرویس های کار با کد تخفیف
    /// </summary>
    [Route("api/[controller]/[action]")]
    [ApiController]
    public class DiscountController : ControllerBase
    {
        private readonly IDiscountContext _ctx;
        public DiscountController(
    IDiscountContext ctx)
        {
            _ctx = ctx;
        }
        /// <summary>
        /// دریافت لیست کد تخفیف ها - سمت ادمین
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> GetByAdmin([FromBody] GetDiscountCode.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.GetDiscountCode(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// ثبت کد تخفیف جدید - سمت ادمین
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPost]
        public async Task<IActionResult> Save([FromBody] Insert_Discount.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Insert_Discount(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// بروز رسانی کد تخفیف - سمت ادمین
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> Update([FromBody] Update_Discount.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Update_Discount(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// حذف کد تخفیف - سمت ادمین
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpDelete]
        public async Task<IActionResult> Delete([FromQuery] Delete_Discount.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Delete_Discount(inputs, cancellationToken);
            return Ok(rst);
        }
    }
}
