﻿using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Farakonesh.Logic.IDatabase.IOrder;
using Farakonesh.Logic.IDatabase.IUser;
using Farakonesh.Models.Database.StoredProcedures.App.Order.Orders;
using Farakonesh.Models.Database.StoredProcedures.App.User.Discount;
using Farakonesh.Models.Database.StoredProcedures.App.User.User;
using System.Threading;
using System.Threading.Tasks;

namespace Farakonesh.API.Controllers.App.User
{
    [Route("api/[controller]/[action]")]
    [ApiController]
    public class DiscountOrderTypeController : ControllerBase
    {
        private readonly IDiscountContext _ctx;
        private readonly IOrderContext _orderContext;
        public DiscountOrderTypeController(IDiscountContext ctx, IOrderContext orderContext)
        {
            _ctx = ctx;
            _orderContext = orderContext;
        }
        [HttpGet]
        [AllowAnonymous]
        public async Task<IActionResult> Get([FromQuery] Get_Discount_OrderType_Servant.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _orderContext.Get_Discount_OrderType_Servant(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// دریافت لیست محدودیت سفارشات برای کد تخفیف - سمت ادمین
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> GetByAdmin([FromBody] GetDiscount_OrderTypeByAdmin.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.GetDiscount_OrderTypeByAdmin(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// افزودن محدودیت نوع سفارش سمت ادمین
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPost]
        public async Task<IActionResult> Save([FromBody] Insert_Discount_OrderType.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Insert_Discount_OrderType(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// بروز رسانی محدودیت نوع سفارش - سمت ادمین
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> Update([FromBody] Update_Discount_OrderType.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Update_Discount_OrderType(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// حذف محدودیت نوع سفارش از کد تخفیف - سمت ادمین
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpDelete]
        public async Task<IActionResult> Delete([FromQuery] Delete_Discount_OrderType.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Delete_Discount_OrderType(inputs, cancellationToken);
            return Ok(rst);
        }
    }
}
