﻿using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Farakonesh.Logic.IDatabase.IUser;
using Farakonesh.Models.Database.StoredProcedures.App.User.Discount;
using Farakonesh.Models.Database.StoredProcedures.App.User;
using System.Threading.Tasks;
using System.Threading;

namespace Farakonesh.API.Controllers.App.User
{
    /// <summary>
    /// سرویس های کار با انتصابات تخفیف
    /// </summary>
    [Route("api/[controller]/[action]")]
    [ApiController]
    public class DiscountUserController : ControllerBase
    {
        private readonly IDiscountContext _ctx;
        public DiscountUserController(
    IDiscountContext ctx)
        {
            _ctx = ctx;
        }
        /// <summary>
        /// دریافت لیست تخفیف و کاربران - سمت ادمین
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> GetByAdmin([FromBody] GetDiscountUser.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.GetDiscountUser(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// انتصاب یک تخفیف به کاربر - سمت ادمین
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPost]
        public async Task<IActionResult> Save([FromBody] Insert_Discount_User.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Insert_Discount_User(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// ریست کردن انتصابات تخفیف از کاربران
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> Reset([FromBody] Reset_Discount_User.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Reset_Discount_User(inputs, cancellationToken);
            return Ok(rst);
        }

        /// <summary>
        /// حذف یک انتصاب تخفیف از کاربر
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpDelete]
        public async Task<IActionResult> Delete([FromQuery] Delete_Discount_User.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Delete_Discount_User(inputs, cancellationToken);
            return Ok(rst);
        }
    }
}
