﻿using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Farakonesh.API.Filters;
using Farakonesh.Commands.Services;
using Farakonesh.Logic.Database;
using Farakonesh.Logic.IDatabase;
using Farakonesh.Logic.IDatabase.idbo;
using Farakonesh.Logic.IDatabase.IUser;
using Farakonesh.Logic.IServices.IApp;
using Farakonesh.Logic.Log;
using Farakonesh.Logic.Services.App;
using Farakonesh.Logic.Services.Cache;
using Farakonesh.Models.Database.StoredProcedures.App.User.User;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading;
using System.Threading.Tasks;

namespace Farakonesh.API.Controllers.App.User
{
    /// <summary>
    /// سرویس کار با سوابق مدارک ارسال شده توسط کاربر
    /// </summary>
    [Route("api/[controller]/[action]")]
	[ApiController]
	public class DocumentController : ControllerBase
	{
		private readonly IUserContext _ctx;
        private readonly ISettingContext _ctxSetting;
        private readonly RedisService _redisService;
        private readonly ILog _logger;
        private readonly IFileService _fileService;
        public DocumentController(
        IUserContext ctx, ISettingContext ctxSetting, RedisService redisService, ILog logger,
        IFileService fileService)
		{
			_ctx = ctx;
			_ctxSetting = ctxSetting;
			_redisService = redisService;
			_logger = logger;
            _fileService = fileService;
		}
		/// <summary>
		/// دریافت لیست سوابق مدارک ارسال شده توسط کاربر - سمت مشتری
		/// </summary>
		/// <param name="inputs"></param>
		/// <returns></returns>
		[HttpPut]
		[CustomersAuth]
		public async Task<IActionResult> Get([FromBody] GetDocuments.Inputs inputs, CancellationToken cancellationToken)
		{
			var rst = await _ctx.GetDocuments(inputs, cancellationToken);
			return Ok(rst);
		}
        /// <summary>
        /// دریافت لیست سوابق مدارک ارسال شده توسط کاربر - سمت ادمین
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> GetByAdmin([FromBody] GetDocumentsByAdmin.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.GetDocumentsByAdmin(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// ارسال یک مدرک جدید - سمت مشتری
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPost]
		[CustomersAuth]
		public async Task<IActionResult> SaveDocument([FromBody] Insert_Document.Inputs inputs, CancellationToken cancellationToken)
		{
			var rst = await _ctx.Insert_Document(inputs, cancellationToken);
			return Ok(rst);
		}
        /// <summary>
        /// تایید خودکار کارت ملی با پردازش تصویر - سمت مشتری - توجه: درصورتی که تایید اتوماتیک با شکست روبرو بشود ، ادمه فرآیند تایید بصورت دستی در پنل ادمین اتفاق می افتد
        /// </summary>
        /// <param name="command"></param>
        /// <returns></returns>
        [HttpPut]
        [CustomersAuth]
        public async Task<IActionResult> AutoVerifyNationalCard([FromBody] VerifyFileNationalCardCommand command, CancellationToken cancellationToken)
        {
            var rst = await _fileService.verifyFileNationalCard(command, cancellationToken);
            return Ok(rst);
        }
    }
}
