﻿using Farakonesh.API.Filters;
using Farakonesh.Logic.IDatabase.IUser;
using Farakonesh.Logic.IServices.IApp.IUser;
using Farakonesh.Models.Database.StoredProcedures.App.User.Wallet;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using System.Threading;
using System.Threading.Tasks;

namespace Farakonesh.API.Controllers.App.User
{
    [Route("api/[controller]/[action]")]
    [ApiController]
    public class FXWalletController : ControllerBase
    {
        private readonly IWalletContext _ctx;
        private readonly IWalletService _walletService;
        public FXWalletController(
            IWalletContext ctx,
            IWalletService walletService)
        {
            _ctx = ctx;
            _walletService = walletService;
        }
        [HttpPut]
        [CustomersAuth]
        public async Task<IActionResult> Get([FromBody] GetMultiCurrencyWalletByCustomer.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.GetMultiCurrencyWalletByCustomer(inputs, cancellationToken);
            return Ok(rst);
        }

        [HttpPut]
        public async Task<IActionResult> GetByAdmin([FromBody] GetMultiCurrencyWalletByAdmin.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.GetMultiCurrencyWalletByAdmin(inputs, cancellationToken);
            return Ok(rst);
        }

        [HttpPost]
        public async Task<IActionResult> CreateByAdmin([FromBody] CreateMultiCurrencyWallet.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.CreateMultiCurrencyWallet(inputs, cancellationToken);
            return Ok(rst);
        }
    }
}
