﻿using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Farakonesh.API.Filters;
using Farakonesh.Logic.IDatabase.idbo;
using Farakonesh.Logic.IDatabase.IUser;
using Farakonesh.Logic.IServices.IApp;
using Farakonesh.Logic.Log;
using Farakonesh.Logic.Services.Cache;
using Farakonesh.Models.Database.StoredProcedures.App.User.User;
using System.Threading.Tasks;
using System.Threading;
using Farakonesh.Models.Database.StoredProcedures.App.User.Gift;

namespace Farakonesh.API.Controllers.App.User
{
    [Route("api/[controller]/[action]")]
    [ApiController]
    public class GiftController : ControllerBase
    {
        private readonly IGiftContext _ctx;
        public GiftController(
        IGiftContext ctx)
        {
            _ctx = ctx;
        }
        /// <summary>
        /// دریافت هدیه - سمت راهبر
        /// </summary>
        /// <param name="inputs"></param>
        /// <param name="cancellationToken"></param>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> Get([FromBody] GetGift.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.GetGift(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// ثبت هدیه - سمت راهبر
        /// </summary>
        /// <param name="inputs"></param>
        /// <param name="cancellationToken"></param>
        /// <returns></returns>
        [HttpPost]
        public async Task<IActionResult> Save([FromBody] Insert_Gift.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Insert_Gift(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// بروز رسانی هدیه - سمت راهبر
        /// </summary>
        /// <param name="inputs"></param>
        /// <param name="cancellationToken"></param>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> Update([FromBody] Update_Gift.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Update_Gift(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// حذف هدیه - سمت راهبر
        /// </summary>
        /// <param name="inputs"></param>
        /// <param name="cancellationToken"></param>
        /// <returns></returns>
        [HttpDelete]
        public async Task<IActionResult> Delete([FromQuery] Delete_Gift.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Delete_Gift(inputs, cancellationToken);
            return Ok(rst);
        }
    }
}
