﻿using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Farakonesh.Logic.IDatabase.IUser;
using Farakonesh.Models.Database.StoredProcedures.App.User.Gift;
using System.Threading.Tasks;
using System.Threading;
using Farakonesh.API.Filters;

namespace Farakonesh.API.Controllers.App.User
{
    [Route("api/[controller]/[action]")]
    [ApiController]
    public class GiftUserController : ControllerBase
    {
        private readonly IGiftContext _ctx;
        public GiftUserController(
        IGiftContext ctx)
        {
            _ctx = ctx;
        }
        /// <summary>
        /// دریافت هدیه های منتصب به کاربر - سمت راهبر
        /// </summary>
        /// <param name="inputs"></param>
        /// <param name="cancellationToken"></param>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> Get([FromBody] GetGiftUser.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.GetGiftUser(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// دریافت لیست هدایای برنده شده - سمت کاربر
        /// </summary>
        /// <param name="inputs"></param>
        /// <param name="cancellationToken"></param>
        /// <returns></returns>
        [HttpPut]
        [CustomersAuth]
        public async Task<IActionResult> GetByCustomer([FromBody] GetGiftByCustomer.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.GetGiftByCustomer(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// انتصاب هدیه به کاربر - سمت راهبر
        /// </summary>
        /// <param name="inputs"></param>
        /// <param name="cancellationToken"></param>
        /// <returns></returns>
        [HttpPost]
        public async Task<IActionResult> Save([FromBody] Insert_GiftUser.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Insert_GiftUser(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// حذف انتصاب هدیه از کاربر - سمت راهبر
        /// </summary>
        /// <param name="inputs"></param>
        /// <param name="cancellationToken"></param>
        /// <returns></returns>
        [HttpDelete]
        public async Task<IActionResult> Delete([FromQuery] Delete_GiftUser.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Delete_GiftUser(inputs, cancellationToken);
            return Ok(rst);
        }
    }
}
