﻿using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Farakonesh.API.Filters;
using Farakonesh.Logic.Database;
using Farakonesh.Logic.IDatabase.IUser;
using Farakonesh.Models.Database.StoredProcedures.App.User.Inbox;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading;
using System.Threading.Tasks;

namespace Farakonesh.API.Controllers.App.User
{
    /// <summary>
    /// سرویس های کار با متون پیغام
    /// </summary>
    [Route("api/[controller]/[action]")]
	[ApiController]
	public class InboxContentController : ControllerBase
	{
		private readonly IInboxContext _ctx;
		public InboxContentController(
    IInboxContext ctx)
		{
			_ctx = ctx;
		}
		/// <summary>
		/// دریافت لیست متون پیغام - سمت مشتری
		/// </summary>
		/// <param name="inputs"></param>
		/// <returns></returns>
		[HttpPut]
		[CustomersAuth]
		public async Task<IActionResult> Get([FromBody] GetInboxContent.Inputs inputs, CancellationToken cancellationToken)
		{
			var rst = await _ctx.GetInboxContent(inputs, cancellationToken);
			return Ok(rst);
		}
		/// <summary>
		/// ثبت متن برای پیغام - سمت ادمین
		/// </summary>
		/// <param name="inputs"></param>
		/// <returns></returns>
		[HttpPost]
		[CustomersAuth]
		public async Task<IActionResult> SaveContent([FromBody] Insert_InboxContent.Inputs inputs, CancellationToken cancellationToken)
		{
			var rst = await _ctx.Insert_InboxContent(inputs, cancellationToken);
			return Ok(rst);
		}
		/// <summary>
		/// بروز رسانی وضعیت پیغام به دیده شده - سمت مشتری و ادمین
		/// </summary>
		/// <param name="inputs"></param>
		/// <returns></returns>
		[HttpPut]
		[CustomersAuth]
		public async Task<IActionResult> UpdateSeen([FromBody] Update_Seen_Inbox.Inputs inputs, CancellationToken cancellationToken)
		{
			var rst = await _ctx.Update_Seen_Inbox(inputs, cancellationToken);
			return Ok(rst);
		}
	}
}
