﻿using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Farakonesh.API.Filters;
using Farakonesh.Commands.Services;
using Farakonesh.Logic.Database;
using Farakonesh.Logic.IDatabase;
using Farakonesh.Logic.IDatabase.idbo;
using Farakonesh.Logic.IDatabase.IQueue;
using Farakonesh.Logic.IDatabase.IUser;
using Farakonesh.Logic.IServices.IApp.IUser;
using Farakonesh.Logic.Services.App;
using Farakonesh.Logic.Services.Cache;
using Farakonesh.Models.Database.StoredProcedures.App.User.Inbox;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading;
using System.Threading.Tasks;

namespace Farakonesh.API.Controllers.App.User
{
    /// <summary>
    /// سرویس های کار با صندوق پیغام
    /// </summary>
    [Route("api/[controller]/[action]")]
	[ApiController]
	public class InboxController : ControllerBase
	{
		private readonly IQueueContext _queueContext;
		private readonly IUserContext _ctxUser;
        private readonly IInboxContext _ctx;
        private readonly IPublicContext _pctx;
        private readonly ISettingContext _settingctx;
        private readonly IInboxService _IInboxService;
        private readonly RedisService _redisService;
        public InboxController(
    IInboxContext ctx, IUserContext ctxUser, IQueueContext queueContext, IPublicContext pctx
			, ISettingContext settingctx, IInboxService IInboxService, RedisService redisService)
		{
			_queueContext = queueContext;
			_ctx = ctx;
			_ctxUser = ctxUser;
			_pctx = pctx;
			_settingctx = settingctx;
			_IInboxService = IInboxService;
			_redisService = redisService;
		}
		/// <summary>
		/// دریافت لیست پیغام ها - سمت مشتری
		/// </summary>
		/// <param name="inputs"></param>
		/// <returns></returns>
		[HttpPut]
		[CustomersAuth]
		public async Task<IActionResult> Get([FromBody] GetInbox.Inputs inputs, CancellationToken cancellationToken)
		{
			var rst = await _ctx.GetInbox(inputs, cancellationToken);
			return Ok(rst);
		}
		/// <summary>
		/// دریافت لیست پیغام ها - سمت ادمین
		/// </summary>
		/// <param name="inputs"></param>
		/// <returns></returns>
		[HttpPut]
		public async Task<IActionResult> GetByAdmin([FromBody] GetInboxByAdmin.Inputs inputs, CancellationToken cancellationToken)
		{
			var rst = await _ctx.GetInboxByAdmin(inputs, cancellationToken);
			return Ok(rst);
		}
		/// <summary>
		/// دریافت اطلاعات یک پیغام باشناسه ی آن
		/// </summary>
		/// <param name="inputs"></param>
		/// <returns></returns>
		[HttpPut]
		[CustomersAuth]
		public async Task<IActionResult> GetById([FromBody] GetInboxById.Inputs inputs, CancellationToken cancellationToken)
		{
			var rst = await _ctx.GetInboxById(inputs,cancellationToken);
			return Ok(rst);
		}
		/// <summary>
		/// ثبت یک پیغام جدید
		/// </summary>
		/// <param name="command"></param>
		/// <returns></returns>
		[HttpPost]
		public async Task<IActionResult> Save([FromBody] SaveInboxCommand command, CancellationToken cancellationToken)
		{
			var rst = await _IInboxService.Insert(command, cancellationToken);
			return Ok(rst);
		}
		/// <summary>
		/// حذف یک پیغام
		/// </summary>
		/// <param name="inputs"></param>
		/// <returns></returns>
		[HttpDelete]
		public async Task<IActionResult> Delete([FromQuery] Delete_Inbox.Inputs inputs, CancellationToken cancellationToken)
		{
			var rst = await _ctx.Delete_Inbox(inputs, cancellationToken);
			return Ok(rst);
		}
	}
}
