﻿using Farakonesh.API.Filters;
using Farakonesh.Commands.Services;
using Farakonesh.Logic.IDatabase.idbo;
using Farakonesh.Logic.IDatabase.IQueue;
using Farakonesh.Logic.IDatabase.IUser;
using Farakonesh.Logic.IServices.IApp.IUser;
using Farakonesh.Logic.Services.Cache;
using Farakonesh.Models.Database.StoredProcedures.App.User.Inbox;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using System.Threading.Tasks;
using System.Threading;
using Farakonesh.Models.Database.StoredProcedures.App.User.InternalNumbers;

namespace Farakonesh.API.Controllers.App.User
{
    [Route("api/[controller]/[action]")]
    [ApiController]
    public class InternalNumbersController : ControllerBase
    {
        private readonly IInternalNumbersContext _ctx;
        public InternalNumbersController(
    IInternalNumbersContext ctx)
        {
            _ctx = ctx;
        }
        /// <summary>
        /// دریافت لیست شماره های داخلی - سمت ادمین
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        [CustomersAuth]
        public async Task<IActionResult> Get([FromBody] GetInternalNumbersByAdmin.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.GetInternalNumbersByAdmin(inputs, cancellationToken);
            return Ok(rst);
        }
     
        /// <summary>
        /// ثبت یک شماره داخلی جدید - سمت ادمین
        /// </summary>
        /// <param name="command"></param>
        /// <returns></returns>
        [HttpPost]
        public async Task<IActionResult> Save([FromBody] Insert_InternalNumbers.Inputs command, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Insert_InternalNumbers(command, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// بروز رسانی شماره داخلی - سمت ادمین
        /// </summary>
        /// <param name="command"></param>
        /// <param name="cancellationToken"></param>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> Update([FromBody] Update_InternalNumbers.Inputs command, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Update_InternalNumbers(command, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// حذف یک شماره داخلی - سمت ادمین
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpDelete]
        public async Task<IActionResult> Delete([FromQuery] Delete_InternalNumbers.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Delete_InternalNumbers(inputs, cancellationToken);
            return Ok(rst);
        }
    }
}
