﻿using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Farakonesh.API.Filters;
using Farakonesh.Logic.IDatabase.IUser;
using Farakonesh.Models.Database.StoredProcedures.App.User.User;
using System.Threading;
using System.Threading.Tasks;

namespace Farakonesh.API.Controllers.App.User
{
    [Route("api/[controller]/[action]")]
    [ApiController]
    public class LanguageController : ControllerBase
    {
        private readonly IUserContext _ctx;
        public LanguageController(
    IUserContext ctx)
        {
            _ctx = ctx;
        }

        [HttpPut]
        [AllowAnonymous]
        public async Task<IActionResult> Update([FromBody] Update_Language_User.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Update_Language_User(inputs, cancellationToken);
            return Ok(rst);
        }
    }
}
