﻿using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Farakonesh.Logic.IDatabase;
using Farakonesh.Logic.IDatabase.IUser;
using Farakonesh.Models.Database.StoredProcedures.App.User;
using Farakonesh.Models.Database.StoredProcedures.App.User.Level;
using System.Threading;
using System.Threading.Tasks;

namespace Farakonesh.API.Controllers.App.User
{
    /// <summary>
    /// کار با سرویس های سطح کاربری
    /// </summary>
    [Route("api/[controller]/[action]")]
    [ApiController]
    public class LevelController : ControllerBase
    {
        private readonly ILevelContext _ctx;
        public LevelController(
    ILevelContext ctx)
        {
            _ctx = ctx;
        }
        /// <summary>
        /// دریافت لیست سطوح کاربری - سمت ادمین
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> Get([FromBody] GetLevelList.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.GetLevelList(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// ثبت یک سطح کاربری جدید - سمت ادمین
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>

        [HttpPost]
        public async Task<IActionResult> Save([FromBody] Insert_Level.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Insert_Level(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// بروز رسانی اطلاعات سطح کاربری - سمت ادمین
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> Update([FromBody] Update_Level.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Update_Level(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// حذف سطح کاربری - سمت ادمین
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>

        [HttpDelete]
        public async Task<IActionResult> Delete([FromQuery] Delete_Level.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Delete_Level(inputs, cancellationToken);
            return Ok(rst);
        }
    }
}
