﻿using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Farakonesh.API.Filters;
using Farakonesh.Logic.Database;
using Farakonesh.Logic.IDatabase.IUser;
using Farakonesh.Models.Database.StoredProcedures.App.User.Location;
using System.Threading;
using System.Threading.Tasks;

namespace Farakonesh.API.Controllers.App.User
{
    [Route("api/[controller]/[action]")]
	[ApiController]
	public class LocationController : ControllerBase
	{
        private readonly IUserContext _ctx;
        public LocationController(
    IUserContext ctx)
		{
			_ctx = ctx;
		}
		[HttpPut]
		[CustomersAuth]
		public async Task<IActionResult> GetProvince([FromBody] GetProvince.Inputs inputs, CancellationToken cancellationToken)
		{
			var rst = await _ctx.GetProvince(inputs, cancellationToken);
			return Ok(rst);
		}

		[HttpPut]
		[CustomersAuth]
		public async Task<IActionResult> GetCity([FromBody] GetCity.Inputs inputs, CancellationToken cancellationToken)
		{
			var rst = await _ctx.GetCity(inputs, cancellationToken);
			return Ok(rst);
		}

		[HttpPost]
		public async Task<IActionResult> Save([FromBody] Insert_Location.Inputs inputs, CancellationToken cancellationToken)
		{
			var rst = await _ctx.Insert_Location(inputs, cancellationToken);
			return Ok(rst);
		}

		[HttpPut]
		public async Task<IActionResult> Update([FromBody] Update_Location.Inputs inputs, CancellationToken cancellationToken)
		{
			var rst = await _ctx.Update_Location(inputs, cancellationToken);
			return Ok(rst);
		}

		[HttpDelete]
		public async Task<IActionResult> Delete([FromQuery] Delete_Location.Inputs inputs, CancellationToken cancellationToken)
		{
			var rst = await _ctx.Delete_Location(inputs, cancellationToken);
			return Ok(rst);
		}
	}
}
