﻿using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Farakonesh.API.Filters;
using Farakonesh.Logic.Database;
using Farakonesh.Logic.IDatabase;
using Farakonesh.Logic.IDatabase.IUser;
using Farakonesh.Models.Database.StoredProcedures.App.User.Ticket;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading;
using System.Threading.Tasks;

namespace Farakonesh.API.Controllers.App.User
{
	/// <summary>
	/// سرویس های کار با دپارتمان های سیستم
	/// </summary>
    [Route("api/[controller]/[action]")]
	[ApiController]
	public class PartController : ControllerBase
	{
		private readonly IPartContext _ctx;

        public PartController(
IPartContext ctx)
		{
		_ctx= ctx;
		}
		/// <summary>
		/// دریافت لیست دپارتمان های سیستم
		/// </summary>
		/// <param name="inputs"></param>
		/// <returns></returns>

		[HttpPut]
		[CustomersAuth]
		public async Task<IActionResult> Get([FromBody] GetPart.Inputs inputs, CancellationToken cancellationToken)
		{
			var rst = await _ctx.GetPart(inputs, cancellationToken);
			return Ok(rst);
		}
		/// <summary>
		/// ثبت دپارتمان جدید
		/// </summary>
		/// <param name="inputs"></param>
		/// <returns></returns>
        [HttpPost]
        public async Task<IActionResult> Save([FromBody] Insert_Part.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Insert_Part(inputs, cancellationToken);
            return Ok(rst);
        }
		/// <summary>
		/// بروز رسانی دپارتمان
		/// </summary>
		/// <param name="inputs"></param>
		/// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> Update([FromBody] Update_Part.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Update_Part(inputs, cancellationToken);
            return Ok(rst);
        }
		/// <summary>
		/// حذف دپارتمان
		/// </summary>
		/// <param name="inputs"></param>
		/// <returns></returns>
        [HttpDelete]
        public async Task<IActionResult> Delete([FromQuery] Delete_Part.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Delete_Part(inputs, cancellationToken);
            return Ok(rst);
        }
    }
}
