﻿using Farakonesh.API.Filters;
using Farakonesh.Logic.IDatabase.IUser;
using Farakonesh.Models.Database.StoredProcedures.App.User.Ticket;
using Farakonesh.Models.Database.StoredProcedures.App.User.User;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using System.Threading;
using System.Threading.Tasks;

namespace Farakonesh.API.Controllers.App.User
{
    [Route("api/[controller]/[action]")]
    [ApiController]
    public class PartUserController : ControllerBase
    {
        private readonly IPartContext _ctx;

        public PartUserController(
IPartContext ctx)
        {
            _ctx = ctx;
        }
        /// <summary>
        /// دریافت انتصاب ها دپارتمان - سمت ادمین
        /// </summary>
        /// <param name="inputs"></param>
        /// <param name="cancellationToken"></param>
        /// <returns></returns>
        [HttpPut]
        [CustomersAuth]
        public async Task<IActionResult> Get([FromBody] GetPartUser.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.GetPartUser(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// ثبت انتصاب دپارتمان - سمت ادمین
        /// </summary>
        /// <param name="inputs"></param>
        /// <param name="cancellationToken"></param>
        /// <returns></returns>
        [HttpPost]
        public async Task<IActionResult> Save([FromBody] Insert_Part_User.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Insert_Part_User(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// حذف انتصاب دپارتمان - سمت ادمین
        /// </summary>
        /// <param name="inputs"></param>
        /// <param name="cancellationToken"></param>
        /// <returns></returns>
        [HttpDelete]
        public async Task<IActionResult> Delete([FromQuery] Delete_Part_User.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Delete_Part_User(inputs, cancellationToken);
            return Ok(rst);
        }
    }
}
