﻿using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Farakonesh.Logic.IDatabase.IUser;
using Farakonesh.Logic.IServices.IApp.IUser;
using Farakonesh.Models.Database.StoredProcedures.App.User.Wallet;
using System.Threading.Tasks;
using System.Threading;
using Farakonesh.Commands.Services;
using Farakonesh.Logic.Services.App;
using Farakonesh.Commands.Services.User;
using Farakonesh.API.Filters;

namespace Farakonesh.API.Controllers.App.User
{
    [Route("api/[controller]/[action]")]
    [ApiController]
    public class PointWalletController : ControllerBase
    {
        private readonly IWalletContext _ctx;
        private readonly IPointWalletService _pointWalletService;
        public PointWalletController(
            IWalletContext ctx, IPointWalletService pointWalletService)
        {
            _ctx = ctx;
            _pointWalletService = pointWalletService;
        }
        /// <summary>
        /// دریافت اطلاعات کیف امتیاز - سمت مشتری
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        [CustomersAuth]
        public async Task<IActionResult> Get([FromBody] GetPointWallet.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.GetPointWallet(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// دریافت لیست کیف امتیاز - سمت ادمین
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> GetByAdmin([FromBody] GetPointWalletByAdmin.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.GetPointWalletByAdmin(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// فعال سازی کیف امتیاز - سمت ادمین
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>

        [HttpPost]
        public async Task<IActionResult> Create([FromBody] CreatePointWallet.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.CreatePointWallet(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// فعال سازی کیف امتیاز - سمت مشتر
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPost]
        [CustomersAuth]
        public async Task<IActionResult> CreateByCustomer([FromBody] CreatePointWalletByCustomer.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.CreatePointWalletByCustomer(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// بروز رسانی موجودی کیف امتیاز - سمت ادمین
        /// </summary>
        /// <param name="command"></param>
        /// <returns></returns>

        [HttpPut]
        public async Task<IActionResult> Update([FromBody] UpdatePointWalletByAdminCommand command, CancellationToken cancellationToken)
        {
            var rst = await _pointWalletService.UpdatePointWalletByAdmin(command, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// تبدیل امتیاز به کیف نقدی - سمت مشتری
        /// </summary>
        /// <param name="command"></param>
        /// <param name="cancellationToken"></param>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> ConvertToWallet([FromBody] ConvertPointWalletToWalletCommand command, CancellationToken cancellationToken)
        {
            var rst = await _pointWalletService.ConvertPointWalletToWallet(command, cancellationToken);
            return Ok(rst);
        }
    }
}
