﻿using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Farakonesh.API.Filters;
using Farakonesh.Logic.IDatabase.IUser;
using Farakonesh.Logic.IServices.IApp.IUser;
using Farakonesh.Models.Database.StoredProcedures.App.User.Wallet;
using System.Threading.Tasks;
using System.Threading;
using Farakonesh.Commands.Services.User;
using Farakonesh.Logic.Services.App.User;

namespace Farakonesh.API.Controllers.App.User
{
    [Route("api/[controller]/[action]")]
    [ApiController]
    public class PointWalletOrderController : ControllerBase
    {
        private readonly IWalletContext _ctx;
        public PointWalletOrderController(
            IWalletContext ctx)
        {
            _ctx = ctx;
        }

        /// <summary>
        /// دریافت لیست شروط امتیاز دهی براساس نوع سفارش- سمت ادمین
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> GetByAdmin([FromBody] GetPointWalletOrderByAdmin.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.GetPointWalletOrderByAdmin(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// ثبت شرط امتیاز دهی براساس نوع سفارش - سمت ادمین
        /// </summary>
        /// <param name="inputs"></param>
        /// <param name="cancellationToken"></param>
        /// <returns></returns>
        [HttpPost]
        public async Task<IActionResult> Insert([FromBody] Insert_PointWalletOrder.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Insert_PointWalletOrder(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// بروز رسانی شرط امتیاز دهی براساس نوع سفارش - سمت ادمین
        /// </summary>
        /// <param name="inputs"></param>
        /// <param name="cancellationToken"></param>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> Update([FromBody] Update_PointWalletOrder.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Update_PointWalletOrder(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// حذف شرط امتیاز دهی براساس نوع سفارش - سمت ادمین
        /// </summary>
        /// <param name="inputs"></param>
        /// <param name="cancellationToken"></param>
        /// <returns></returns>
        [HttpDelete]
        public async Task<IActionResult> Delete([FromQuery] Delete_PointWalletOrder.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Delete_PointWalletOrder(inputs, cancellationToken);
            return Ok(rst);
        }
    }
}
