﻿using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Farakonesh.Logic.IDatabase.IUser;
using Farakonesh.Models.Database.StoredProcedures.App.User.User;
using System.Threading;
using System.Threading.Tasks;

namespace Farakonesh.API.Controllers.App.User
{
    /// <summary>
    /// سرویس های کار با انتصابات نقش کاربران
    /// </summary>
    [Route("api/[controller]/[action]")]
    [ApiController]
    public class RoleUserController : ControllerBase
    {
        private readonly IUserContext _ctx;

        public RoleUserController(
IUserContext ctx)
        {
            _ctx = ctx;
        }
        /// <summary>
        /// بروز رسانی نقش کاربر - سمت ادمین
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> Update([FromBody] Update_User_Role.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Update_User_Role(inputs, cancellationToken);
            return Ok(rst);
        }
    }
}
