﻿using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Farakonesh.API.Filters;
using Farakonesh.Logic.Database;
using Farakonesh.Logic.IDatabase;
using Farakonesh.Logic.IDatabase.IUser;
using Farakonesh.Models.Database.StoredProcedures.App.User.Ticket;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading;
using System.Threading.Tasks;

namespace Farakonesh.API.Controllers.App.User
{
	/// <summary>
	/// سرویس های کار با موضوعات تیکت
	/// </summary>
    [Route("api/[controller]/[action]")]
	[ApiController]
	public class SubjectController : ControllerBase
	{
		private readonly ISubjectContext _ctx;
        public SubjectController(
    ISubjectContext ctx)
		{
			_ctx = ctx;
		}
		/// <summary>
		/// دریافت لیست موضوعات تیکت
		/// </summary>
		/// <param name="inputs"></param>
		/// <returns></returns>
		[HttpPut]
		[CustomersAuth]
		public async Task<IActionResult> Get([FromBody] GetSubject.Inputs inputs, CancellationToken cancellationToken)
		{
			var rst = await _ctx.GetSubject(inputs, cancellationToken);
			return Ok(rst);
		}
        /// <summary>
        /// ثبت موضوع جدید
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPost]
        public async Task<IActionResult> Save([FromBody] Insert_Subject.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Insert_Subject(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// بروز رسانی موضوع
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> Update([FromBody] Update_Subject.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Update_Subject(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// حذف موضوع
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpDelete]
        public async Task<IActionResult> Delete([FromQuery] Delete_Subject.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Delete_Subject(inputs, cancellationToken);
            return Ok(rst);
        }

    }
}
