﻿using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Farakonesh.API.Filters;
using Farakonesh.Logic.IDatabase.IUser;
using Farakonesh.Models.Database.StoredProcedures.App.User.Ticket;
using Farakonesh.Models.Database.StoredProcedures.App.User.User;
using System.Threading;
using System.Threading.Tasks;

namespace Farakonesh.API.Controllers.App.User
{
    [Route("api/[controller]/[action]")]
    [ApiController]
    public class SubjectUserController : ControllerBase
    {
        private readonly ISubjectContext _ctx;
        public SubjectUserController(
    ISubjectContext ctx)
        {
            _ctx = ctx;
        }
        /// <summary>
        /// دریافت لیست موضوعات منتصب به راهبر لاگین شده
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> Get([FromBody] GetSubject_User.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.GetSubject_User(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// دریافت لیست موضوعات منتصب به راهبران
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> GetAll([FromBody] GetSubject_UserAll.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.GetSubject_UserAll(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// انتصاب موضوع به کاربر
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPost]
        public async Task<IActionResult> Save([FromBody] Insert_Subject_User.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Insert_Subject_User(inputs, cancellationToken);
            return Ok(rst);
        }
    }
}
