﻿using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Farakonesh.API.Filters;
using Farakonesh.Logic.IDatabase.IUser;
using Farakonesh.Models.Database.StoredProcedures.App.User.Survey;
using Farakonesh.Models.Database.StoredProcedures.App.User.Ticket;
using System.Threading;
using System.Threading.Tasks;

namespace Farakonesh.API.Controllers.App.User
{
    [Route("api/[controller]/[action]")]
    [ApiController]
    public class SurveyController : ControllerBase
    {
        private readonly IUserContext _ctx;
        public SurveyController(
    IUserContext ctx)
        {
            _ctx = ctx;
        }
        /// <summary>
        /// ثبت امتیاز توسط مشتری
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPost]
        [CustomersAuth]
        public async Task<IActionResult> Save([FromBody] Insert_Survey.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Insert_Survey(inputs, cancellationToken);
            return Ok(rst);
        }
    }
}
