﻿using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Farakonesh.API.Filters;
using Farakonesh.Commands.Services;
using Farakonesh.Logic.Database;
using Farakonesh.Logic.IDatabase;
using Farakonesh.Logic.IDatabase.idbo;
using Farakonesh.Logic.IDatabase.IQueue;
using Farakonesh.Logic.IDatabase.IUser;
using Farakonesh.Logic.IServices.IApp.IUser;
using Farakonesh.Logic.Services.App;
using Farakonesh.Logic.Services.Cache;
using Farakonesh.Models.Database.StoredProcedures.App.User;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading;
using System.Threading.Tasks;

namespace Farakonesh.API.Controllers.App.User
{
    /// <summary>
    /// سرویس های کار با گفتگو های تیکت
    /// </summary>
    [Route("api/[controller]/[action]")]
    [ApiController]
    public class TicketContentController : ControllerBase
    {
        private readonly ITicketService _ticketService;
        public TicketContentController(ITicketService ticketService)
        {
            _ticketService = ticketService;
        }
        /// <summary>
        /// دریافت لیست گفتگو های تیکت
        /// </summary>
        /// <param name="command"></param>
        /// <returns></returns>
        [HttpPut]
        [CustomersAuth]
        public async Task<IActionResult> Get([FromBody] GetTicketContentCommand command, CancellationToken cancellationToken)
        {
            var rst = await _ticketService.GetTicketContent(command, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// دریافت لیست گفتگو های تیکت - سمت ادمین
        /// </summary>
        /// <param name="command"></param>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> GetByAdmin([FromBody] GetTicketContentCommand command, CancellationToken cancellationToken)
        {
            var rst = await _ticketService.GetTicketContentByAdmin(command, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// ثبت یک گفتگوی جدید در تیکت
        /// </summary>
        /// <param name="command"></param>
        /// <returns></returns>
        [HttpPost]
        [CustomersAuth]
        public async Task<IActionResult> Save([FromBody] InsertContentCommand command, CancellationToken cancellationToken)
        {
            var rst = await _ticketService.InsertContent(command, cancellationToken);
            return Ok(rst);
        }


    }
}
