﻿using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Farakonesh.API.Filters;
using Farakonesh.Commands.Services;
using Farakonesh.Logic.Database;
using Farakonesh.Shared.Exceptions;
using Farakonesh.Logic.IDatabase;
using Farakonesh.Logic.IDatabase.idbo;
using Farakonesh.Logic.IDatabase.IQueue;
using Farakonesh.Logic.IDatabase.IUser;
using Farakonesh.Logic.IServices.IApp.IUser;
using Farakonesh.Logic.Services.App;
using Farakonesh.Logic.Services.Cache;
using Farakonesh.Models.Database.StoredProcedures.App.User.Ticket;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using System.Threading;
using Farakonesh.Models.Database.StoredProcedures.App.User.User;

namespace Farakonesh.API.Controllers.App.User
{
    /// <summary>
    /// کار با سرویس های تیکت
    /// </summary>
    [Route("api/[controller]/[action]")]
	[ApiController]
	public class TicketController : ControllerBase
	{
		private readonly ITicketContext _ctx;
		private readonly ITicketService _ticketService;
        public TicketController(
ITicketContext ctx,
ITicketService ticketService)
		{
			_ctx = ctx;
			_ticketService = ticketService;
		}
		/// <summary>
		/// دریافت لیست تیکت های کاربر
		/// </summary>
		/// <param name="inputs"></param>
		/// <returns></returns>
		[HttpPut]
		[CustomersAuth]
		public async Task<IActionResult> GetAll([FromBody] GetTicket.Inputs inputs, CancellationToken cancellationToken)
		{
            var rst = await _ctx.GetTicket(inputs, cancellationToken);
			return Ok(rst);
		}

        [HttpPut]
        [CustomersAuth]
        public async Task<IActionResult> GetFull([FromBody] GetFullTicketCommand command, CancellationToken cancellationToken)
        {
            var rst = await _ticketService.getFull(command, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// دریافت لیست تیکت ها - سمت ادمین
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
		public async Task<IActionResult> GetAllByAdmin([FromBody] GetTicketByAdmin.Inputs inputs, CancellationToken cancellationToken)
		{
			var rst = await _ctx.GetTicketByAdmin(inputs, cancellationToken);
			return Ok(rst);
		}

		/// <summary>
		/// گزارش تیکت ها - سمت ادمین
		/// </summary>
		/// <param name="inputs"></param>
		/// <param name="cancellationToken"></param>
		/// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> GetTicketReportByAdmin([FromBody] GetTicketReportByAdmin.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.GetTicketReportByAdmin(inputs, cancellationToken);
            return Ok(rst);
        }

        /// <summary>
        /// دریافت یک تیکت با شناسه آن
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
		[CustomersAuth]
		public async Task<IActionResult> GetById([FromBody] GetTicketById.Inputs inputs, CancellationToken cancellationToken)
		{
			var rst = await _ctx.GetTicketById(inputs, cancellationToken);
			return Ok(rst);
		}
		/// <summary>
		/// ثبت یک تیکت جدید - سمت مشتری
		/// </summary>
		/// <param name="inputs"></param>
		/// <returns></returns>
		[HttpPost]
		[CustomersAuth]
		public async Task<IActionResult> Save([FromBody] Insert_Ticket.Inputs inputs, CancellationToken cancellationToken)
		{
			var rst = await _ctx.Insert_Ticket(inputs, cancellationToken);
			return Ok(rst);
		}
        /// <summary>
        /// ثبت یک تیکت جدید - سمت ادمین
        /// </summary>
        /// <param name="command"></param>
        /// <returns></returns>
        [HttpPost]
		public async Task<IActionResult> SaveByAdmin([FromBody] InsertTicketByAdminCommand command, CancellationToken cancellationToken)
		{
			var rst = await _ticketService.InsertTicketByAdmin(command, cancellationToken);
			return Ok(rst);
		}
		/// <summary>
		/// بروز رسانی وضعیت تیکت
		/// </summary>
		/// <param name="inputs"></param>
		/// <returns></returns>
		[HttpPut]
		public async Task<IActionResult> UpdateStatus([FromBody] Update_Ticket_Status.Inputs inputs, CancellationToken cancellationToken)
		{
			var rst = await _ctx.Update_Ticket_Status(inputs, cancellationToken);
			return Ok(rst);
		}
		/// <summary>
		/// حذف تیکت توسط راهبر
		/// </summary>
		/// <param name="inputs"></param>
		/// <returns></returns>

        [HttpDelete]
        public async Task<IActionResult> Delete([FromQuery] Delete_Ticket.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Delete_Ticket(inputs, cancellationToken);
            return Ok(rst);
        }
    }
}
