﻿using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Farakonesh.Logic.IDatabase.IUser;
using Farakonesh.Logic.IServices.IApp.IUser;
using Farakonesh.Models.Database.StoredProcedures.App.User.User;
using System.Threading;
using System.Threading.Tasks;

namespace Farakonesh.API.Controllers.App.User
{
    [Route("api/[controller]/[action]")]
    [ApiController]
    public class UserConfigController : ControllerBase
    {
        private readonly IUserContext _ctx;
        public UserConfigController(
            IUserContext userContext)
        {
            _ctx = userContext;
        }
        /// <summary>
        /// دریافت تنظیمات حساب کاربر - سمت ادمین
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> Get([FromBody] Get_Config_User_Wallet.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Get_Config_User_Wallet(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// بروز رسانی تنظیمات حساب کاربر - سمت ادمین
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> Update([FromBody] Update_User_Wallet_Config.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Update_User_Wallet_Config(inputs, cancellationToken);
            return Ok(rst);
        }
    }
}
