﻿using Farakonesh.API;
using Farakonesh.Logic.Services.App;
using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Mvc;
using Microsoft.Extensions.Configuration;
using System.Threading.Tasks;
using Farakonesh.Logic.Database;
using Farakonesh.API.Filters;
using Farakonesh.Logic.Log;
using Farakonesh.Logic.IDatabase;
using Farakonesh.Models.Database.StoredProcedures.App.User.User;
using Farakonesh.Models.Database.StoredProcedures.App.User.Authentication;
using Farakonesh.Logic.IDatabase.IUser;
using Farakonesh.Logic.Services.App.User;
using Farakonesh.Logic.IDatabase.idbo;
using Farakonesh.Logic.Services.Cache;
using Farakonesh.Logic.IDatabase.IQueue;
using Farakonesh.Logic.IServices.IApp.IUser;
using Farakonesh.Commands.Services;
using System.Threading;
using Farakonesh.Commands.Services.User;
using Farakonesh.Commands.Services.HttpRequest;

namespace Farakonesh.API.Controllers.App.User
{
    /// <summary>
    /// سرویس های کار با کاربران
    /// </summary>
    [Route("api/[controller]/[action]")]
    [ApiController]
    public class UserController : ControllerBase
    {
        private readonly IUserContext _ctx;
        private readonly IAuthenticationContext _iAuthenticationContext;
        private readonly IAuthServices _authServices;
        private readonly IUserServices _userServices;
        public UserController(
            IUserContext userContext, IAuthServices authServices, IUserServices userServices, IAuthenticationContext iAuthenticationContext)
        {
            _ctx = userContext;
            _authServices = authServices;
            _userServices = userServices;
            _iAuthenticationContext = iAuthenticationContext;
        }
        /// <summary>
        /// ورود کاربر با نام کاربری و رمز
        /// </summary>
        /// <param name="command"></param>
        /// <returns></returns>
        [HttpPut]
        [AllowAnonymous]
        public async Task<IActionResult> Login([FromBody] LoginCommand command, CancellationToken cancellationToken)
        {
            var rst = await _authServices.Login(command, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// ورود مجموعه ی همکار با نام کاربری و رمز
        /// </summary>
        /// <param name="command"></param>
        /// <returns></returns>
        [HttpPut]
        [AllowAnonymous]
        public async Task<IActionResult> LoginCompany([FromBody] LoginCommand command, CancellationToken cancellationToken)
        {
            var rst = await _authServices.LoginCompany(command, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// خروج کاربر و مجموعه
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        [CustomersAuth]
        public async Task<IActionResult> SignOut([FromBody] SignOut.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _iAuthenticationContext.SignOut(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// دریافت امضای کاربری جدید - اصطلاحا رفرش توکن
        /// </summary>
        /// <param name="command"></param>
        /// <returns></returns>
        [HttpPut]
        [AllowAnonymous]
        public async Task<IActionResult> Refresh([FromBody] RefreshTokenCommand command, CancellationToken cancellationToken)
        {
            var rst = await _authServices.Refresh(command, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// دریافت اطلاعات کاربر - سمت مشتری
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        [CustomersAuth]
        public async Task<IActionResult> Get([FromBody] GetUser.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.GetUser(inputs, cancellationToken);
            return Ok(rst);
        }

        [HttpPut]
        public async Task<IActionResult> Search([FromBody] GetUserListSearch.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.GetUserListSearch(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// سرویس دریافت اطلاعات کامل کاربر و اطلاعات بیشتر مثل تعداد تیکت های باز - لیست سفارش ها و غیره
        /// </summary>
        /// <returns></returns>

        [HttpPut]
        [CustomersAuth]
        public async Task<IActionResult> GetFull(GetFullUser.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.GetFullUser(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// دریافت اطلاعات کاربر با شناسه ی آن - سمت ادمین
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> GetByAdminId([FromBody] GetUserByIdAdmin.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.GetUserByIdAdmin(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// دریافت لیست کاربران - سمت ادمین
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> GetList([FromBody] GetUserList.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.GetUserList(inputs, cancellationToken);
            return Ok(rst);
        }

        /// <summary>
        /// بروز رسانی اطلاعات پایه ی کاربر - سمت مشتری
        /// </summary>
        /// <param name="command"></param>
        /// <returns></returns>
        [HttpPut]
        [CustomersAuth]
        public async Task<IActionResult> UpdateProfile([FromBody] UpdateProfileCommand command, CancellationToken cancellationToken)
        {
            var rst = await _userServices.UpdateProfile(command, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// بروز رسانی تصویر پروفایل - سمت مشتری
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        [CustomersAuth]
        public async Task<IActionResult> UpdateProfileAvatar([FromBody] Update_Profile_Avatar.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Update_Profile_Avatar(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// صحت سنجی اطلاعات پایه ی کاربر - مثل کد ملی و غیره - سمت ادمین
        /// </summary>
        /// <param name="command"></param>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> CheckBasicInformationByAdmin([FromBody] CheckBasicInformationByAdminCommand command, CancellationToken cancellationToken)
        {
            var rst = await _userServices.checkBasicInformationByAdmin(command, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// صحت سنجی شاهکار - سمت ادمین
        /// </summary>
        /// <param name="command"></param>
        /// <param name="cancellationToken"></param>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> CheckShahkarByAdmin([FromBody] JibitInquiryShahkarCommand command, CancellationToken cancellationToken)
        {
            await _userServices.JibitInquiryShahkar(command, _ctx, cancellationToken);
            return Ok();
        }
        /// <summary>
        /// ثبت کاربر جدید - سمت ادمین
        /// </summary>
        /// <param name="command"></param>
        /// <returns></returns>
        [HttpPost]
        public async Task<IActionResult> InsertUser([FromBody] SaveNewUserCommand command, CancellationToken cancellationToken)
        {
            var rst = await _userServices.SaveNewUser(command, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// بروز رسانی اطلاعات کاربر - سمت ادمین
        /// </summary>
        /// <param name="command"></param>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> UpdateUser([FromBody] UpdateUserCommand command, CancellationToken cancellationToken)
        {
            var rst = await _userServices.UpdateUser(command, cancellationToken);
            return Ok(rst);
        }

        /// <summary>
        /// تغییر وضعیت حساب کاربر - مسدود , باز
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> ChangeStatus([FromBody] Update_User_Active_IsActive.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Update_User_Active_IsActive(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// آزاد سازی امکان تغییر اطلاعات توسط مشتری - سمت ادمین
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> ChangeLockUpdate([FromBody] Change_User_LockUpdate.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Change_User_LockUpdate(inputs, cancellationToken);
            return Ok(rst);
        }

        /// <summary>
        /// بروز رسانی رمز - سمت مشتری
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        [CustomersAuth]
        public async Task<IActionResult> UpdatePassword([FromBody] Update_Password.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Update_Password(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// تولید اتوماتیک رمز عبور و ارسال آن برای کاربر
        /// </summary>
        /// <param name="command"></param>
        /// <returns></returns>
        [HttpPut]
        [CustomersAuth]
        public async Task<IActionResult> AutoGenerateNewPassword([FromBody] SendNewPasswordCommand command, CancellationToken cancellationToken)
        {
            var rst = await _userServices.sendNewPassword(command, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// بروز رسانی رمز مشتری - سمت ادمین
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> UpdatePasswordByAdmin([FromBody] Update_PasswordByAdmin.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Update_PasswordByAdmin(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// حذف کاربر - سمت ادمین
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpDelete]
        public async Task<IActionResult> Delete([FromQuery] Delete_User.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Delete_User(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// تایید توکن ورود با گوگل
        /// </summary>
        /// <param name="command"></param>
        /// <returns></returns>
        [HttpPut]
        [AllowAnonymous]
        public async Task<IActionResult> VerifyOAuth([FromBody] VerifyGoogleCommand command, CancellationToken cancellationToken)
        {
            var rst = await _authServices.verifyGoogle(command, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// حذف رمز کاربر
        /// </summary>
        /// <param name="inputs"></param>
        /// <param name="cancellationToken"></param>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> RestPassword([FromBody] Reset_User_Password.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Reset_User_Password(inputs, cancellationToken);
            return Ok(rst);
        }
    }
}
