﻿using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Farakonesh.API.Filters;
using Farakonesh.Logic.IDatabase.IUser;
using Farakonesh.Models.Database.StoredProcedures.App.User.User;
using System.Threading;
using System.Threading.Tasks;

namespace Farakonesh.API.Controllers.App.User
{
    [Route("api/[controller]/[action]")]
    [ApiController]
    public class UserSettingController : ControllerBase
    {
        private readonly IUserContext _ctx;
        public UserSettingController(
            IUserContext userContext)
        {
            _ctx = userContext;
        }
        /// <summary>
        /// دریافت تنظیمات سفارش - سمت کاربر کاربر
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        [CustomersAuth]
        public async Task<IActionResult> Get([FromBody] Get_Setting_User.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Get_Setting_User(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// دریافت تنظیمات سفارش - سمت راهبر
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> GetByAdmin([FromBody] Get_Setting_User_ByAdmin.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Get_Setting_User_ByAdmin(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// ثبت تنظیمات سفارش برای کاربر - سمت ادمین
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPost]
        public async Task<IActionResult> Save([FromBody] Insert_Setting_User.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Insert_Setting_User(inputs, cancellationToken);
            return Ok(rst);
        }
    }
}
