﻿using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Farakonesh.API.Filters;
using Farakonesh.Commands.Services;
using Farakonesh.Logic.Database;
using Farakonesh.Logic.IDatabase;
using Farakonesh.Logic.IDatabase.idbo;
using Farakonesh.Logic.IDatabase.IQueue;
using Farakonesh.Logic.IDatabase.IUser;
using Farakonesh.Logic.IServices.IApp.IUser;
using Farakonesh.Logic.Services.App;
using Farakonesh.Logic.Services.Cache;
using Farakonesh.Models.Database.StoredProcedures.App.User.User;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading;
using System.Threading.Tasks;

namespace Farakonesh.API.Controllers.App.User
{
    /// <summary>
    /// سرویس های کار با تایید مدارک و اطلاعات کاربران
    /// </summary>
    [Route("api/[controller]/[action]")]
    [ApiController]
    public class UserVerifyingController : ControllerBase
    {
        private readonly IUserContext _ctx;
        private readonly IUserVerifyService _userVerifyService;
        public UserVerifyingController(
    IUserContext ctx, IQueueContext queueContext, ISettingContext settingctx
            , RedisService redisService, IUserVerifyService userVerifyService)
        {
            _ctx = ctx;
            _userVerifyService = userVerifyService;
        }
        /// <summary>
        /// دریافت لیست اطلاعات ارسال شده کاربران جهت تایید - سمت مشتری
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        [CustomersAuth]
        public async Task<IActionResult> GetUserVerifying([FromBody] GetUserVerifying.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.GetUserVerifying(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// دریافت لیست اطلاعات ارسال شده کاربران جهت تایید - سمت ادمین
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> GetUserVerifyingAll([FromBody] GetUserVerifyingAll.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.GetUserVerifyingAll(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// تایید یا عدم تایید اطلاعات ارسال شده توسط کاربر - سمت ادمین
        /// </summary>
        /// <param name="command"></param>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> Accept([FromBody] AcceptUserVerifyCommand command, CancellationToken cancellationToken)
        {
            var rst = await _userVerifyService.accept(command,cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// ثبت تاییدیه برای کاربران - سمت ادمین
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPost]
        public async Task<IActionResult> Save([FromBody] Insert_UserVerifying.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Insert_UserVerifying(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// حذف تاییدیه کاربر - سمت ادمین
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpDelete]
        public async Task<IActionResult> Delete([FromQuery] Delete_UserVerifying.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Delete_UserVerifying(inputs, cancellationToken);
            return Ok(rst);
        }
    }
}
