﻿using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Microsoft.Extensions.Configuration;
using Farakonesh.API.Filters;
using Farakonesh.Logic.IDatabase.idbo;
using Farakonesh.Logic.IDatabase.IQueue;
using Farakonesh.Logic.IDatabase.IUser;
using Farakonesh.Logic.IDatabase;
using Farakonesh.Logic.Log;
using Farakonesh.Logic.Services.App;
using Farakonesh.Logic.Services.Cache;
using System.Threading.Tasks;
using Farakonesh.Logic.IServices.IApp.IUser;
using Farakonesh.Commands.Services;
using System.Threading;

namespace Farakonesh.API.Controllers.App.User
{
    /// <summary>
    /// سرویس های کار با ثبت نام و وریفای کاربران توسط کمپانی ها
    /// </summary>
    [Route("api/[controller]/[action]")]
    [ApiController]
    public class VerifyCodeCompanyController : ControllerBase
    {
        readonly IConfiguration _configuration;
        private readonly IUserContext _ctx;
        private readonly IAuthenticationContext _authenticationContext;
        private readonly IPublicContext _pctx;
        private readonly IQueueContext _queueContext;
        private readonly RedisService _redisService;
        private readonly ISettingContext _settingCtx;
        private readonly ILog _logger;
        private readonly IAuthServices _iAuthServices;
        public VerifyCodeCompanyController(
        IUserContext ctx, IAuthenticationContext authenticationContext, IPublicContext pctx, IQueueContext queueContext
            , ISettingContext settingctx
            , IConfiguration configuration, RedisService redisService, ILog logger,
        IAuthServices iAuthServices)
        {
            _configuration = configuration;
            _ctx = ctx;
            _pctx = pctx;
            _queueContext = queueContext;
            _settingCtx = settingctx;
            _redisService = redisService;
            _logger = logger;
            _authenticationContext = authenticationContext;
            _iAuthServices = iAuthServices;
        }

        /// <summary>
        /// ارسال کد یکبار مصرف به شماره همراه کاربر جدید
        /// </summary>
        /// <param name="command"></param>
        /// <returns></returns>
        [HttpPost]
        [CompanyAuth]
        public async Task<IActionResult> Send([FromBody] SendCodeInCompanyCommand command, CancellationToken cancellationToken)
        {
            var rst = await _iAuthServices.SendCodeByCompany(command, cancellationToken);
            return Ok(rst);
        }

        /// <summary>
        /// ارسال کد یکبار مصرف به شماره همراه کابری که قبلا در سیستم ثبت نام کرده ولی میخواهد زیر مجموعه ی یک شرکت بشود
        /// </summary>
        /// <param name="command"></param>
        /// <param name="cancellationToken"></param>
        /// <returns></returns>
        [HttpPost]
        [CompanyAuth]
        public async Task<IActionResult> SendInPanel([FromBody] SendCodeInCompanyCommand command, CancellationToken cancellationToken)
        {
            var rst = await _iAuthServices.SendCodeByCompanyInPanel(command, cancellationToken);
            return Ok(rst);
        }


        /// <summary>
        /// تایید کد - توسط کاربر برای کمپانی خوانده می شود
        /// </summary>
        /// <param name="command"></param>
        /// <returns></returns>
        [HttpPost]
        [CompanyAuth]
        public async Task<IActionResult> Verify([FromBody] VerifyCompanyCommand command, CancellationToken cancellationToken)
        {
            var rst = await _iAuthServices.VerifyByCompany(command, cancellationToken);
            return Ok(rst);
        }
    }
}
