﻿using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using System.Threading.Tasks;
using Farakonesh.Logic.Database;
using Farakonesh.Logic.Services.App;
using Microsoft.Extensions.Configuration;
using Farakonesh.API.Filters;
using Farakonesh.Logic.IDatabase;
using Farakonesh.Models.Database.StoredProcedures.App.User.Authentication;
using Farakonesh.Logic.Services.Cache;
using Farakonesh.Logic.Log;
using Farakonesh.Logic.Services.App.User;
using Farakonesh.Logic.IDatabase.idbo;
using Farakonesh.Logic.IDatabase.IUser;
using Farakonesh.Logic.IDatabase.IQueue;
using Farakonesh.Logic.IServices.IApp.IUser;
using Farakonesh.Commands.Services;
using System.Threading;
using Farakonesh.Commands.Services.User;
using Farakonesh.Shared.Exceptions;

namespace Farakonesh.API.Controllers.App.User
{
    /// <summary>
    /// کار با سرویس های ارسال و تایید کد یکبار مصرف - به روش های ایمیل - پیامک - تماس
    /// </summary>
    [Route("api/[controller]/[action]")]
    [ApiController]
    public class VerifyCodeController : ControllerBase
    {
        private readonly IAuthenticationContext _iAuthenticationContext;
        private readonly IAuthServices _authServices;
        public VerifyCodeController(
       IAuthServices authServices, IAuthenticationContext iAuthenticationContext)
        {
            _authServices = authServices;
            _iAuthenticationContext = iAuthenticationContext;
        }

        /// <summary>
        /// ارسال کد یکبار مصرف - بدون امضای کاربری
        /// </summary>
        /// <param name="command"></param>
        /// <returns></returns>
        [HttpPost]
        [AllowAnonymous]
        public async Task<IActionResult> Send([FromBody] SendCodeLoginCommand command, CancellationToken cancellationToken)
        {
            var rst = await _authServices.SendCodeLogin(command, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// ارسال کد یکبار مصرف با نیاز به امضای کاربری
        /// </summary>
        /// <param name="command"></param>
        /// <returns></returns>
        [HttpPost]
        [CustomersAuth]
        public async Task<IActionResult> SendInPanel([FromBody] SendCodeInPanelCommand command, CancellationToken cancellationToken)
        {
            var rst = await _authServices.SendCodeInPanel(command, cancellationToken);
            return Ok(rst);
        }

        /// <summary>
        /// تایید کد بدون نیاز به امضای کاربری
        /// </summary>
        /// <param name="command"></param>
        /// <returns></returns>
        [HttpPost]
        [AllowAnonymous]
        public async Task<IActionResult> Verify([FromBody] VerifyCommand command, CancellationToken cancellationToken)
        {
            var rst = await _authServices.Verify(command, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// تایید کد با نیاز به امضای کاربری
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPost]
        [CustomersAuth]
        public async Task<IActionResult> VerifyInPanel([FromBody] VeriyCode_Email_Tel.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _iAuthenticationContext.VeriyCode_Email_Tel(inputs, cancellationToken);
            return Ok(rst);
        }

     
        /// <summary>
        /// ارسال مجدد کد یکبار مصرف
        /// </summary>
        /// <param name="command"></param>
        /// <returns></returns>

        [HttpPost]
        [AllowAnonymous]
        public async Task<IActionResult> ReSend([FromBody] ReSendCodeCommand command, CancellationToken cancellationToken)
        {
            var rst = await _authServices.ReSendCode(command, cancellationToken);
            return Ok(rst);
        }

    }
}
