﻿using Microsoft.AspNetCore.Mvc;
using Farakonesh.API.Filters;
using Farakonesh.Commands.Services;
using Farakonesh.Logic.IDatabase;
using Farakonesh.Logic.IDatabase.idbo;
using Farakonesh.Logic.IDatabase.IQueue;
using Farakonesh.Logic.IDatabase.IUser;
using Farakonesh.Logic.IServices.IApp.IUser;
using Farakonesh.Logic.Services.App;
using Farakonesh.Logic.Services.Cache;
using Farakonesh.Models.Database.StoredProcedures.App.User.Wallet;
using System.Threading;
using System.Threading.Tasks;

namespace Farakonesh.API.Controllers.App.User
{
    /// <summary>
    /// سرویس های کار با کیف پول
    /// </summary>
    [Route("api/[controller]/[action]")]
    [ApiController]
    public class WalletController : ControllerBase
    {
        private readonly IWalletContext _ctx;
        private readonly IWalletService _walletService;
        public WalletController(
            IWalletContext ctx,
            IWalletService walletService)
        {
            _ctx = ctx;
            _walletService = walletService;
        }
        /// <summary>
        /// دریافت اطلاعات کیف پول - سمت مشتری
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        [CustomersAuth]
        public async Task<IActionResult> Get([FromBody] GetWallet.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.GetWallet(inputs,cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// دریافت لیست کیف پول - سمت ادمین
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> GetByAdmin([FromBody] GetWalletByAdmin.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.GetWalletByAdmin(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// فعال سازی کیف پول - سمت ادمین
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>

        [HttpPost]
        public async Task<IActionResult> Create([FromBody] CreateWallet.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.CreateWallet(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// فعال سازی کیف پول - سمت مشتر
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPost]
        [CustomersAuth]
        public async Task<IActionResult> CreateByCustomer([FromBody] CreateWalletByCustomer.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.CreateWalletByCustomer(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// بروز رسانی موجودی کیف پول - سمت ادمین
        /// </summary>
        /// <param name="command"></param>
        /// <returns></returns>

        [HttpPut]
        public async Task<IActionResult> Update([FromBody] UpdateWalletByAdminCommand command, CancellationToken cancellationToken)
        {
            var rst = await _walletService.updateWalletByAdmin(command, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// بروز رسانی تنظیمات کیف پول
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> UpdateWalletSetting([FromBody] Update_User_Setting_Wallet.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Update_User_Setting_Wallet(inputs, cancellationToken);
            return Ok(rst);
        }

    }
}
