﻿using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Farakonesh.Logic.IDatabase.idbo;
using Farakonesh.Models.Database.StoredProcedures.App.dbo.accountInformation;
using System.Threading;
using System.Threading.Tasks;

namespace Farakonesh.API.Controllers.App.dbo
{
    /// <summary>
    /// سرویس های کار با اطلاعات حساب
    /// </summary>
    [Route("api/[controller]/[action]")]
    [ApiController]
    public class AccountInformationController : ControllerBase
    {
        private readonly IAccountInformationContext _ctx;

        public AccountInformationController(
    IAccountInformationContext ctx)
        {
            _ctx = ctx;
        }
        /// <summary>
        /// دریافت لیست اطلاعات حساب
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> Get([FromBody] Get_AccountInformation.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Get_AccountInformation(inputs, cancellationToken);
            return Ok(rst);
        }

        /// <summary>
        /// ثبت یک اطلاعات حساب
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPost]
        public async Task<IActionResult> Save([FromBody] Insert_AccountInformation.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Insert_AccountInformation(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// بروز رسانی یک اطلاعات حساب
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> Update([FromBody] Update_AccountInformation.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Update_AccountInformation(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// حذف یک اطلاعات حساب
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpDelete]
        public async Task<IActionResult> Delete([FromQuery] Delete_AccountInformation.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Delete_AccountInformation(inputs, cancellationToken);
            return Ok(rst);
        }
    }
}
