﻿using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Farakonesh.Logic.IDatabase.idbo;
using Farakonesh.Models.Database.StoredProcedures.App.dbo.accountInformation;
using Farakonesh.Models.Database.StoredProcedures.App.dbo.accountService;
using System.Threading;
using System.Threading.Tasks;

namespace Farakonesh.API.Controllers.App.dbo
{
    [Route("api/[controller]/[action]")]
    [ApiController]
    public class AccountServiceController : ControllerBase
    {
        private readonly IAccountServiceContext _ctx;


        public AccountServiceController(
    IAccountServiceContext ctx)
        {
            _ctx = ctx;
        }
        /// <summary>
        /// دریافت لیست حساب سرویس
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> Get([FromBody] Get_AccountService.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Get_AccountService(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// ثبت حساب سرویس
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPost]
        public async Task<IActionResult> Save([FromBody] Insert_AccountService.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Insert_AccountService(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// بروز رسانی اطلاعات حساب سرویس
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> Update([FromBody] Update_AccountService.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Update_AccountService(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// تمدید تاریخ سرویس باتوجه به دوره ی پرداخت
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> Renewal([FromBody] Update_AccountService_Renewal.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Update_AccountService_Renewal(inputs, cancellationToken);
            return Ok(rst);
        }

        /// <summary>
        /// حذف یک اطلاعات حساب سرویس
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpDelete]
        public async Task<IActionResult> Delete([FromQuery] Delete_AccountService.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Delete_AccountService(inputs, cancellationToken);
            return Ok(rst);
        }
    }
}
