﻿using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using NSwag.Annotations;
using Farakonesh.API.Filters;
using Farakonesh.Logic.Database;
using Farakonesh.Logic.IDatabase.idbo;
using Farakonesh.Models.Database.StoredProcedures.App.dbo.bank;
using System.Collections.Generic;
using System.Net;
using System.Threading;
using System.Threading.Tasks;

namespace Farakonesh.API.Controllers.App.dbo
{
    /// <summary>
    /// سرویس های کار با بانک ها
    /// </summary>
    [Route("api/[controller]/[action]")]
	[ApiController]
	public class BankController : ControllerBase
	{
		private readonly IPublicContext _ctx;
		public BankController(
		IPublicContext ctx)
		{
			_ctx = ctx;
		}
		/// <summary>
		/// دریافت لیست بانک هایی که به سیستم متصل می باشند
		/// </summary>
		/// <param name="inputs"></param>
		/// <returns></returns>
		[HttpPut]
        [SwaggerResponse(HttpStatusCode.OK, typeof(Models.Database.DBResult<List<GetBank.Outputs>>), Description = "Returns a list of banks")]
        public async Task<IActionResult> Get([FromBody] GetBank.Inputs inputs, CancellationToken cancellationToken)
		{
			var rst = await _ctx.GetBank(inputs, cancellationToken);
			return Ok(rst);
		}
		/// <summary>
		/// دریافت یک بانک با کلید اصلی
		/// </summary>
		/// <param name="inputs"></param>
		/// <returns></returns>
		[HttpPut]
		[SwaggerResponse(HttpStatusCode.OK, typeof(Models.Database.DBResult<GetBankById.Outputs>), Description = "Returns the object containing data bank details by bankId")]
        public async Task<IActionResult> GetById([FromBody] GetBankById.Inputs inputs, CancellationToken cancellationToken)
		{
			var rst = await _ctx.GetBankById(inputs, cancellationToken);
			return Ok(rst);
		}
		/// <summary>
		/// اتصال یک بانک به سیستم
		/// </summary>
		/// <param name="inputs"></param>
		/// <returns></returns>
		[HttpPost]
		public async Task<IActionResult> Insert([FromBody] GetBankById.Inputs inputs, CancellationToken cancellationToken)
		{
			var rst = await _ctx.GetBankById(inputs, cancellationToken);
			return Ok(rst);
		}
		/// <summary>
		/// بروز رسانی یک بانک در سیستم
		/// </summary>
		/// <param name="inputs"></param>
		/// <returns></returns>
		[HttpPut]
		public async Task<IActionResult> Update([FromBody] GetBankById.Inputs inputs, CancellationToken cancellationToken)
		{
			var rst = await _ctx.GetBankById(inputs, cancellationToken);
			return Ok(rst);
		}

	}
}
