﻿using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Farakonesh.Logic.IDatabase.idbo;
using Farakonesh.Logic.IDatabase.IUser;
using Farakonesh.Models.Database.StoredProcedures.App.dbo.accountInformation;
using Farakonesh.Models.Database.StoredProcedures.App.dbo.blackList;
using System.Threading;
using System.Threading.Tasks;

namespace Farakonesh.API.Controllers.App.dbo
{
    [Route("api/[controller]/[action]")]
    [ApiController]
    public class BlackListController : ControllerBase
    {
        private readonly IBlackListContext _ctx;

        public BlackListController(
    IBlackListContext ctx)
        {
            _ctx = ctx;
        }
        /// <summary>
        /// دریافت لیست آی پی ها
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> Get([FromBody] GetBlackList.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.GetBlackList(inputs, cancellationToken);
            return Ok(rst);
        }

        /// <summary>
        /// ثبت یک آی پی در لیست سیاه
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPost]
        public async Task<IActionResult> Save([FromBody] Insert_BlackList.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Insert_BlackList(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// بروز رسانی آی پی در لیست سیاه
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> Update([FromBody] Update_BlackList.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Update_BlackList(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// حذف آی پی از لیست سیاه
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpDelete]
        public async Task<IActionResult> Delete([FromQuery] Delete_BlackList.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Delete_BlackList(inputs, cancellationToken);
            return Ok(rst);
        }
    }
}
