﻿using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using NSwag.Annotations;
using Farakonesh.Logic.IDatabase;
using Farakonesh.Logic.IDatabase.idbo;
using Farakonesh.Models.Database.StoredProcedures.App.dbo.menu;
using System.Collections.Generic;
using System.Net;
using System.Threading;
using System.Threading.Tasks;
using Farakonesh.API.Filters;

namespace Farakonesh.API.Controllers.App.dbo
{
    /// <summary>
    /// سرویس های کار با منو ها
    /// </summary>
    [Route("api/[controller]/[action]")]
    [ApiController]
    public class MenusController : ControllerBase
    {
        private readonly IMenusContext _ctx;
        public MenusController(
        IMenusContext ctx)
        {
            _ctx = ctx;
        }
        /// <summary>
        /// سرویس جستجوی منو و صفحه
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        [AllowAnonymous]
        [SwaggerResponse(HttpStatusCode.OK, typeof(Models.Database.DBResult<List<Search_Menus.Outputs>>), Description = "Returns a list of menus with search")]
        public async Task<IActionResult> Search([FromBody] Search_Menus.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Search_Menus(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// دریافت لیست تمام منو منو ها که در سمت ادمین نمایش داده می شوند
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        [SwaggerResponse(HttpStatusCode.OK, typeof(Models.Database.DBResult<List<GetAll_Menus.Outputs>>), Description = "Returns a list of menus")]
        public async Task<IActionResult> GetAll([FromBody] GetAll_Menus.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.GetAll_Menus(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// دریافت لیست دسترسی های یک صفحه
        /// </summary>
        /// <param name="inputs"></param>
        /// <param name="cancellationToken"></param>
        /// <returns></returns>
        [HttpPut]
        [AllowAnonymousCustome]
        public async Task<IActionResult> GetAccess([FromBody] Get_Access_Menus.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Get_Access_Menus(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// دریافت لیست تمام منو ها در سمت پنل مشتری
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        [AllowAnonymous]
        [SwaggerResponse(HttpStatusCode.OK, typeof(Models.Database.DBResult<List<Get_Menus.Outputs>>), Description = "Returns a list of menus in customer panel")]
        public async Task<IActionResult> GetAllMenu([FromBody] Get_Menus.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Get_Menus(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// ثبت دسترسی برای مشاهده منو
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPost]
        [SwaggerResponse(HttpStatusCode.OK, typeof(Models.Database.DBResult<List<Insert_Menus_Access_Role.Outputs>>), Description = "Save access menu")]
        public async Task<IActionResult> SaveAccess([FromBody] Insert_Menus_Access_Role.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Insert_Menus_Access_Role(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// ثبت یک منوی جدید
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPost]
        [SwaggerResponse(HttpStatusCode.OK, typeof(Models.Database.DBResult<Insert_Menu.Outputs>), Description = "Save menu")]
        public async Task<IActionResult> Save([FromBody] Insert_Menu.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Insert_Menu(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// بروز رسانی منو
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        [SwaggerResponse(HttpStatusCode.OK, typeof(Models.Database.DBResult<Update_Menu.Outputs>), Description = "Update menu")]
        public async Task<IActionResult> Update([FromBody] Update_Menu.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Update_Menu(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// حذف منو
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpDelete]
        [SwaggerResponse(HttpStatusCode.OK, typeof(Models.Database.DBResult<Delete_Menu.Outputs>), Description = "Delete menu")]
        public async Task<IActionResult> Delete([FromQuery] Delete_Menu.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Delete_Menu(inputs, cancellationToken);
            return Ok(rst);
        }
    }
}
