﻿using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Farakonesh.API.Filters;
using Farakonesh.Logic.IDatabase.idbo;
using Farakonesh.Models.Database.StoredProcedures.App.dbo.question;
using System.Threading;
using System.Threading.Tasks;

namespace Farakonesh.API.Controllers.App.dbo
{
    /// <summary>
    /// سرویس های کار با سوالات متداول
    /// </summary>
    [Route("api/[controller]/[action]")]
    [ApiController]
    public class QuestionsController : ControllerBase
    {
        private readonly IQuestionsContext _ctx;

        public QuestionsController(
    IQuestionsContext ctx)
        {
            _ctx = ctx;
        }
        /// <summary>
        /// دریافت لیست سوالات متداول در سمت مشتری
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [AllowAnonymous]
        [HttpPut]
        public async Task<IActionResult> Get([FromBody] Get_Question.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Get_Question(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// دریافت لیست تمام سوالات متداول در سمت ادمین
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> GetByAdmin([FromBody] Get_QuestionByAdmin.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Get_QuestionByAdmin(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// ثبت یک سوال متداول جدید
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPost]
        public async Task<IActionResult> Save([FromBody] Insert_Question.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Insert_Question(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// بروز رسانی یک سوال متداول
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> Update([FromBody] Update_Question.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Update_Question(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// حذف یک سوال متداول
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpDelete]
        public async Task<IActionResult> Delete([FromQuery] Delete_Question.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Delete_Question(inputs, cancellationToken);
            return Ok(rst);
        }
    }
}
