﻿using Farakonesh.Logic.IDatabase.idbo;
using Farakonesh.Models.Database.StoredProcedures.App.dbo.question;
using Farakonesh.Models.Database.StoredProcedures.App.dbo.rfm;
using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using System.Threading;
using System.Threading.Tasks;

namespace Farakonesh.API.Controllers.App.dbo
{
    [Route("api/[controller]/[action]")]
    [ApiController]
    public class RFMCategoryDefinitionsController : ControllerBase
    {
        private readonly IRFMCategoryDefinitionsContext _ctx;

        public RFMCategoryDefinitionsController(
    IRFMCategoryDefinitionsContext ctx)
        {
            _ctx = ctx;
        }
        /// <summary>
        /// دریافت لیست دسته بندی های سیستم - سمت ادمین
        /// </summary>
        /// <param name="inputs"></param>
        /// <param name="cancellationToken"></param>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> Get([FromBody] Get_RFMCategoryDefinitions.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Get_RFMCategoryDefinitions(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// ثبت دسته بندی مشتری - سمت ادمین
        /// </summary>
        /// <param name="inputs"></param>
        /// <param name="cancellationToken"></param>
        /// <returns></returns>
        [HttpPost]
        public async Task<IActionResult> Save([FromBody] Insert_RFMCategoryDefinitions.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Insert_RFMCategoryDefinitions(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// بروز رسانی دسته بندی مشتری - سمت ادمین
        /// </summary>
        /// <param name="inputs"></param>
        /// <param name="cancellationToken"></param>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> Update([FromBody] Update_RFMCategoryDefinitions.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Update_RFMCategoryDefinitions(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// حذف دسته بندی مشتری - سمت ادمین
        /// </summary>
        /// <param name="inputs"></param>
        /// <param name="cancellationToken"></param>
        /// <returns></returns>
        [HttpDelete]
        public async Task<IActionResult> Delete([FromQuery] Delete_RFMCategoryDefinitions.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Delete_RFMCategoryDefinitions(inputs, cancellationToken);
            return Ok(rst);
        }
    }
}
