﻿using Farakonesh.Logic.IDatabase.idbo;
using Farakonesh.Models.Database.StoredProcedures.App.dbo.rfm;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using System.Threading;
using System.Threading.Tasks;

namespace Farakonesh.API.Controllers.App.dbo
{
    [Route("api/[controller]/[action]")]
    [ApiController]
    public class RFMScoreRangeController : ControllerBase
    {
        private readonly IRFMScoreRangeContext _ctx;

        public RFMScoreRangeController(
    IRFMScoreRangeContext ctx)
        {
            _ctx = ctx;
        }
        /// <summary>
        /// دریافت تنظیمات امتیاز دهی - سمت ادمین
        /// </summary>
        /// <param name="inputs"></param>
        /// <param name="cancellationToken"></param>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> Get([FromBody] Get_RFMScoreRange.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Get_RFMScoreRange(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// ثبت تنظیمات امتیازدهی - سمت ادمین
        /// </summary>
        /// <param name="inputs"></param>
        /// <param name="cancellationToken"></param>
        /// <returns></returns>
        [HttpPost]
        public async Task<IActionResult> Save([FromBody] Insert_RFMScoreRange.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Insert_RFMScoreRange(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// بروزرسانی تنظیمات امتیاز دهی - سمت ادمین
        /// </summary>
        /// <param name="inputs"></param>
        /// <param name="cancellationToken"></param>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> Update([FromBody] Update_RFMScoreRange.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Update_RFMScoreRange(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// حذف تنظیمات امتیاز دهی - سمت ادمین
        /// </summary>
        /// <param name="inputs"></param>
        /// <param name="cancellationToken"></param>
        /// <returns></returns>
        [HttpDelete]
        public async Task<IActionResult> Delete([FromQuery] Delete_RFMScoreRange.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Delete_RFMScoreRange(inputs, cancellationToken);
            return Ok(rst);
        }

    }
}
