﻿using Farakonesh.Commands.Services.dbo;
using Farakonesh.Logic.IDatabase.idbo;
using Farakonesh.Logic.IServices.IApp.Idbo;
using Farakonesh.Models.Database.StoredProcedures.App.dbo.blackList;
using Farakonesh.Models.Database.StoredProcedures.App.dbo.keys;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using System.Threading;
using System.Threading.Tasks;

namespace Farakonesh.API.Controllers.App.dbo
{
    [Route("api/[controller]/[action]")]
    [ApiController]
    public class ServiceKeysController : ControllerBase
    {
        private readonly IServiceKeysContext _ctx;
        private readonly IServiceKeysService _serviceKeysService;

        public ServiceKeysController(IServiceKeysContext ctx, IServiceKeysService serviceKeysService)
        {
            _ctx = ctx;
            _serviceKeysService = serviceKeysService;
        }
        /// <summary>
        /// دریافت لیست کلید های اتصال - سمت ادمین
        /// </summary>
        /// <param name="inputs"></param>
        /// <param name="cancellationToken"></param>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> Get([FromBody] Get_ServiceKeysByAdmin.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Get_ServiceKeysByAdmin(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// ثبت کلید اتصال - سمت ادمین
        /// </summary>
        /// <param name="inputs"></param>
        /// <param name="cancellationToken"></param>
        /// <returns></returns>
        [HttpPost]
        public async Task<IActionResult> Save([FromBody] InsertServiceKeysByAdminCommand inputs, CancellationToken cancellationToken)
        {
            var rst = await _serviceKeysService.InsertServiceKeys(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// بروز رسانی کلید های اتصال - سمت ادمین
        /// </summary>
        /// <param name="inputs"></param>
        /// <param name="cancellationToken"></param>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> Update([FromBody] UpdateServiceKeysByAdminCommand inputs, CancellationToken cancellationToken)
        {
            var rst = await _serviceKeysService.UpdateServiceKeys(inputs, cancellationToken);
            return Ok(rst);
        }

        /// <summary>
        /// حذف کلید اتصال - سمت ادمین
        /// </summary>
        /// <param name="inputs"></param>
        /// <param name="cancellationToken"></param>
        /// <returns></returns>
        [HttpDelete]
        public async Task<IActionResult> Delete([FromQuery] Delete_ServiceKeysByAdmin.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Delete_ServiceKeysByAdmin(inputs, cancellationToken);
            return Ok(rst);
        }
    }
}
