﻿using Farakonesh.Logic.IDatabase.idbo;
using Farakonesh.Models.Database.StoredProcedures.App.dbo.versionHistory;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using System.Threading.Tasks;
using System.Threading;
using Farakonesh.Models.Database.StoredProcedures.App.dbo.settingJobs;

namespace Farakonesh.API.Controllers.App.dbo
{
    [Route("api/[controller]/[action]")]
    [ApiController]
    public class SettingJobsController : ControllerBase
    {
        private readonly ISettingJobsContext _ctx;

        public SettingJobsController(
    ISettingJobsContext ctx)
        {
            _ctx = ctx;
        }
        /// <summary>
        /// دریافت تنظیمات جاب - سمت ادمین
        /// </summary>
        /// <param name="inputs"></param>
        /// <param name="cancellationToken"></param>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> GetAll([FromBody] Get_SettingJobs.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Get_SettingJobs(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// ثبت تنظیمات جاب - سمت ادمین
        /// </summary>
        /// <param name="inputs"></param>
        /// <param name="cancellationToken"></param>
        /// <returns></returns>
        [HttpPost]
        public async Task<IActionResult> Save([FromBody] Insert_SettingJobs.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Insert_SettingJobs(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// بروز رسانی تنظیمات جاب - سمت ادمین
        /// </summary>
        /// <param name="inputs"></param>
        /// <param name="cancellationToken"></param>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> Update([FromBody] Update_SettingJobs.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Update_SettingJobs(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// حذف تنظیمات جاب - سمت ادمین
        /// </summary>
        /// <param name="inputs"></param>
        /// <param name="cancellationToken"></param>
        /// <returns></returns>
        [HttpDelete]
        public async Task<IActionResult> Delete([FromQuery] Delete_SettingJobs.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Delete_SettingJobs(inputs, cancellationToken);
            return Ok(rst);
        }
    }
}
