﻿using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Farakonesh.API.Filters;
using Farakonesh.Logic.IDatabase;
using Farakonesh.Logic.IDatabase.idbo;
using Farakonesh.Models.Database.StoredProcedures.App.dbo.setting;
using System.Threading;
using System.Threading.Tasks;
using Farakonesh.Logic.IServices.ICache;
using System.Security.Cryptography;
using Farakonesh.Models.Database;

namespace Farakonesh.API.Controllers.App.dbo
{
    /// <summary>
    /// سرویس های کار با تنظیمات سفارش ها
    /// </summary>
    [Route("api/[controller]/[action]")]
    [ApiController]
    public class SettingOrderController : ControllerBase
    {
        private readonly ISettingContext _ctx;
        private readonly IPublicContext _pctx;
        private readonly IRedisContextService _redisContextService;
        public SettingOrderController(
    ISettingContext ctx, IPublicContext pctx, IRedisContextService redisContextService)
        {
            _ctx = ctx;
            _pctx = pctx;
            _redisContextService = redisContextService;
        }
        /// <summary>
        /// دریافت تنظیمات یک نوع سفارش در سمت مشتری
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        [CustomersAuth]
        public async Task<IActionResult> Get([FromBody] Get_Order_Setting.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _pctx.Get_Order_Setting(inputs, cancellationToken);
            return Ok(rst);
        }

        /// <summary>
        /// دریافت تنظیمات یک نوع سفارش برای سمت ادمین
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> GetByAdmin([FromBody] Get_Order_Setting_Admin.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Get_Order_Setting_Admin(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// ثبت یک تنظیم جدید
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPost]
        public async Task<IActionResult> Save([FromBody] Insert_Order_Setting.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Insert_Order_Setting(inputs, cancellationToken);
            return Ok(rst);
        }
    }
}
