﻿using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Farakonesh.Logic.IDatabase.idbo;
using System.Threading.Tasks;
using System.Threading;
using Farakonesh.Models.Database.StoredProcedures.App.dbo.setting;
using Microsoft.AspNetCore.Authorization;

namespace Farakonesh.API.Controllers.App.dbo
{
    [Route("api/[controller]/[action]")]
    [ApiController]
    public class SettingPatternSMSController : ControllerBase
    {
        private readonly ISettingContext _settingContext;
        public SettingPatternSMSController(ISettingContext settingContext)
        {
            _settingContext = settingContext;
        }
        [HttpPut]
        public async Task<IActionResult> GetAll([FromBody]Get_SettingPatternSMS.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _settingContext.Get_SettingPatternSMS(inputs, cancellationToken);
            return Ok(rst);
        }

        [HttpPut]
        [AllowAnonymous]
        public async Task<IActionResult> Get([FromBody] Get_SettingPatternSMS_WithoutToken.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _settingContext.Get_SettingPatternSMS_WithoutToken(inputs, cancellationToken);
            return Ok(rst);
        }

        [HttpPost]
        public async Task<IActionResult> Save([FromBody] Insert_SettingPatternSMS.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _settingContext.Insert_SettingPatternSMS(inputs, cancellationToken);
            return Ok(rst);
        }

        [HttpPost]
        public async Task<IActionResult> SaveGroup([FromBody] Insert_SettingPatternSMS_Group.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _settingContext.Insert_SettingPatternSMS_Group(inputs, cancellationToken);
            return Ok(rst);
        }

        [HttpPut]
        public async Task<IActionResult> Update([FromBody] Update_SettingPatternSMS.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _settingContext.Update_SettingPatternSMS(inputs, cancellationToken);
            return Ok(rst);
        }
        [HttpDelete]
        public async Task<IActionResult> Delete([FromQuery] Delete_SettingPatternSMS.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _settingContext.Delete_SettingPatternSMS(inputs, cancellationToken);
            return Ok(rst);
        }
    }
}
