﻿using Dapper;
using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Microsoft.Extensions.Configuration;
using Newtonsoft.Json;
using Farakonesh.API.Filters;
using Farakonesh.Commands.Services;
using Farakonesh.Commands.Services.HttpRequest;
using Farakonesh.Commands.Services.Order;
using Farakonesh.Shared.Exceptions;
using Farakonesh.Logic.CommonOperations;
using Farakonesh.Logic.Database;
using Farakonesh.Logic.IDatabase;
using Farakonesh.Logic.IDatabase.idbo;
using Farakonesh.Logic.IDatabase.IQueue;
using Farakonesh.Logic.IServices.IApp.IOrder;
using Farakonesh.Logic.IServices.IApp.ISms;
using Farakonesh.Logic.IServices.ICache;
using Farakonesh.Logic.IServices.IRestRequest;
using Farakonesh.Logic.Log;
using Farakonesh.Logic.Services.App;
using Farakonesh.Logic.Services.App.Payeer;
using Farakonesh.Logic.Services.App.Sms;
using Farakonesh.Logic.Services.Cache;
using Farakonesh.Models.Database;
using Farakonesh.Models.Database.StoredProcedures.App.dbo.setting;
using Farakonesh.Models.Database.StoredProcedures.App.Queue;
using StackExchange.Redis;
using System;
using System.Threading;
using System.Threading.Tasks;
using Farakonesh.Logic.ICommonOperations;
using Farakonesh.Shared.Enums;
using Farakonesh.Logic.IServices.IApp.Idbo;
using Farakonesh.Models.Database.StoredProcedures.App.dbo.keys;

namespace Farakonesh.API.Controllers.App.dbo
{
    /// <summary>
    /// سرویس های کار با تنظیمات کلی برنامه
    /// </summary>
    [Route("api/[controller]/[action]")]
    [ApiController]
    public class SettingsController : ControllerBase
    {
        private readonly ISettingContext _ctx;
        private readonly IServiceKeysContext _serviceKeysContext;
        private readonly IWhatsappHelper _whatsappHelper;
        private readonly ISmsService _ISmsService;
        private readonly RedisService _redisService;
        private readonly IPayeerService _payeerService;
        private readonly IHttpRequestCrawler _httpRequestCrawler;
        private readonly IHttpRequestSmsIr _httpRequestSmsIr;
        private readonly IRedisContextService _redisContextService;
        public SettingsController(
    ISettingContext ctx
            , IWhatsappHelper whatsappHelper, RedisService redisService,
    ISmsService ISmsService,IPayeerService payeerService,
    IHttpRequestCrawler httpRequestCrawler, 
    IRedisContextService redisContextService, IHttpRequestSmsIr httpRequestSmsIr,
    IServiceKeysContext serviceKeysContext)
        {
            _serviceKeysContext = serviceKeysContext;
            _ctx = ctx;
            _whatsappHelper = whatsappHelper;
            _redisService = redisService;
            _ISmsService = ISmsService;
            _payeerService = payeerService;
            _httpRequestCrawler = httpRequestCrawler;
            _redisContextService = redisContextService;
            _httpRequestSmsIr = httpRequestSmsIr;
        }
        /// <summary>
        /// دریافت تنظیمات سرویس پیامکی - با کید دسترسی
        /// </summary>
        /// <param name="auth"></param>
        /// <returns></returns>
        /// <exception cref="Exception"></exception>
        [HttpGet]
        [AllowAnonymous]
        [CheckServiceKey]
        public async Task<IActionResult> GetSMSSetting(CancellationToken cancellationToken)
        {
            
            var setting = await _redisContextService.getSettingSmsAsync(cancellationToken);

            return Ok(new DBResult(setting, 1));
        }

        [HttpGet("{id}")]
        [AllowAnonymous]
        [CheckServiceKey]
        public async Task<IActionResult> GetWebServiceSetting([FromRoute] WebServiceType id,CancellationToken cancellationToken)
        {

            var setting = await _redisContextService.GetWebserviceAsync(id,cancellationToken);
            return Ok(new DBResult(setting, 1));
        }
        [HttpGet("{id}")]
        [AllowAnonymous]
        [CheckServiceKey]
        public async Task<IActionResult> UpdateWebServiceSetting([FromRoute] Guid id, CancellationToken cancellationToken)
        {

            var setting = await _serviceKeysContext.Update_ServiceKeys_ByJob(new Update_ServiceKeys_ByJob.Inputs { ServiceKeysId  = id }, cancellationToken);
            return Ok(setting);
        }
        /// <summary>
        /// دریافت تنظیمات سرویس تلگرام - با کید دسترسی
        /// </summary>
        /// <returns></returns>
        /// <exception cref="Exception"></exception>
        [HttpGet]
        [AllowAnonymous]
        [CheckServiceKey]
        public async Task<IActionResult> GetTelegramSetting(CancellationToken cancellationToken)
        {
            
            var setting = await _redisContextService.GetSettingTelegramAsync(cancellationToken);

            return Ok(new DBResult(setting, 1));
        }
     
       
        /// <summary>
        /// دریافت تنظیمات ایمیل - با کید دسترسی
        /// </summary>
        /// <param name="auth"></param>
        /// <returns></returns>
        [HttpGet]
        [AllowAnonymous]
        [CheckServiceKey]
        public async Task<IActionResult> GetEmailSetting(CancellationToken cancellationToken)
        {
            
            var setting = await _redisContextService.GetSettingEmailAsync(cancellationToken);

            return Ok(new DBResult(setting, 1));
        }
        
        /// <summary>
        /// دریافت تنظیمات عمومی برای شارژ کیف پول
        /// </summary>
        /// <returns></returns>
        [HttpGet]
        [AllowAnonymous]
        public async Task<IActionResult> GetWalletSetting(CancellationToken cancellationToken)
        {
            var setting = await _redisService.Get<Get_Setting_Wallet.Outputs>("settingWallet");
            if (setting == null)
            {
                var rst = await _ctx.Get_Setting_Wallet(new Get_Setting_Wallet.Inputs { }, cancellationToken);
                setting = await _redisService.Set<Get_Setting_Wallet.Outputs>("settingWallet", rst.Data);
            }
            return Ok(new DBResult(setting, 1));
        }
        /// <summary>
        /// دریافت تنظیمات فرم های احراز هویت
        /// </summary>
        /// <returns></returns>
        [HttpGet]
        [AllowAnonymous]
        public async Task<IActionResult> GetAuthSetting(CancellationToken cancellationToken)
        {

            var setting = await _redisContextService.GetSettingAuthAsync(cancellationToken);
            return Ok(new DBResult(setting, 1));
        }

        /// <summary>
        /// دریافت دامنه عمومی سیستم
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpGet]
        [AllowAnonymous]
        public async Task<IActionResult> GetDomain([FromQuery] Get_Setting_Domain.Inputs inputs, CancellationToken cancellationToken)
        {
            var setting = await _redisService.Get<Get_Setting_Domain.Outputs>("settingDomain");
            if (setting == null)
            {
                var rst = await _ctx.Get_Setting_Domain(new Get_Setting_Domain.Inputs { }, cancellationToken);
                setting = await _redisService.Set<Get_Setting_Domain.Outputs>("settingDomain", rst.Data);
            }
            return Ok(new DBResult(setting, 1));
        }
        /// <summary>
        /// دریافت آدرس عمومی کالبک تکمیل سفارش پایر
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpGet]
        [AllowAnonymous]
        public async Task<IActionResult> GetCallbackPayeer(CancellationToken cancellationToken)
        {
            var response = await _redisContextService.GetWebserviceAsync(WebServiceType.Payeer,cancellationToken);
            var config = response.AdditionalConfig.JsonParse();
            return Ok(new DBResult(new { UrlCallbackSellPayeer = (string)config["verifyAddressSell"] }, 1));
        }
        /// <summary>
        /// دریافت کلید عمومی اتصال پایر
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpGet]
        [AllowAnonymous]
        [CheckServiceKey]
        public async Task<IActionResult> GetSKPayeer(CancellationToken cancellationToken)
        {
            var response = await _redisContextService.GetWebserviceAsync(WebServiceType.Payeer, cancellationToken);
            var config = response.AdditionalConfig.JsonParse();
            return Ok(new DBResult(new { SecretKeyPayeer = (string)config["apiKeySell"] }, 1));
        }
        /// <summary>
        /// دریافت اطلاعات پایه ی سیستم شامل: لوگو ، آدرس سایت و پنل و عنوان سایت
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpGet]
        [AllowAnonymous]
        public async Task<IActionResult> GetBasic([FromQuery] Get_Setting_Logo_Title_Url.Inputs inputs, CancellationToken cancellationToken)
        {
            var setting = await _redisService.Get<Get_Setting_Logo_Title_Url.Outputs>("settingLogoTitleUrl");
            if (setting == null)
            {
                var rst = await _ctx.Get_Setting_Logo_Title_Url(new Get_Setting_Logo_Title_Url.Inputs { }, cancellationToken);
                setting = await _redisService.Set<Get_Setting_Logo_Title_Url.Outputs>("settingLogoTitleUrl", rst.Data);
            }
            return Ok(new DBResult(setting, 1));
        }



        /// <summary>
        /// دریافت تمامی تنظیمات سیستم در سمت ادمین
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> Get([FromBody] Get_Setting_Admin.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Get_Setting_Admin(inputs, cancellationToken);
            return Ok(rst);
        }

        /// <summary>
        /// مشاهده اطلاعات حساب پایر
        /// </summary>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> GetPayeerBalance(CancellationToken cancellationToken)
        {
            var rst = await _payeerService.getAccountBalance(cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// صحت سنجی یک حساب پایر - سمت ادمین استفاده می شود
        /// </summary>
        /// <param name="command"></param>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> CheckAccountPayeer([FromBody] GetCheckAccountNamePayeerCommand command, CancellationToken cancellationToken)
        {
            var rst = await _payeerService.getCheckAccountName(command, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// دریافت سابقه ی تراکنش های پایر
        /// </summary>
        /// <param name="command"></param>
        /// <returns></returns>
        [HttpPut]
        [AllowAnonymous]
        public async Task<IActionResult> GetHistoryPayeer([FromBody] GetHistoryPayeerCommand command, CancellationToken cancellationToken)
        {
            var rst = await _payeerService.getHistory(command, cancellationToken);
            return Ok(rst);
        }

        /// <summary>
        /// بررسی وضعیت اتصال پایر - سمت ادمین استفاده می شود
        /// </summary>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> CheckPayeerAuth(CancellationToken cancellationToken)
        {
            var rst = await _payeerService.checkAuthAccount(cancellationToken);
            return Ok(rst);
        }
      
        /// <summary>
        /// دریافت اطلاعات حساب پنل پیامکی کاوه نگار
        /// </summary>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> getKavenegarInfo(CancellationToken cancellationToken)
        {
            var rst = await _ISmsService.getKavenegarBalance(cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// دریافت اطلاعات پیامکی پنل ملی پیامک
        /// </summary>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> getMeliPayamakInfo(CancellationToken cancellationToken)
        {
            var rst = await _ISmsService.getMeliPayamakBalance(cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// دریافت موجودی حساب اس ام اس آی آر
        /// </summary>
        /// <param name="cancellationToken"></param>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> getSmsIrCredit(CancellationToken cancellationToken)
        {
            var rst = await _httpRequestSmsIr.getCredit(cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// دریافت وضعیت اتصال به سرویس واتساپ
        /// </summary>
        /// <param name="cancellationToken"></param>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> GetStatusWhatsapp(CancellationToken cancellationToken)
        {
            var rst = await _whatsappHelper.GetStatusWhatsapp(cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// دریافت اطلاعات سرویس واتساپ
        /// </summary>
        /// <param name="cancellationToken"></param>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> GetInfoWhatsapp(CancellationToken cancellationToken)
        {
            var rst = await _whatsappHelper.GetMeWhatsapp(cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// دریافت محتوای داینامیک داشبورد
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        [AllowAnonymous]
        public async Task<IActionResult> GetDashboardContent([FromBody] Get_Setting_Dashboard.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Get_Setting_Dashboard(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// دریافت محتوای داینامیک قوانین و مقررات
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        [AllowAnonymous]
        public async Task<IActionResult> GetTermsConditions([FromBody] Get_Setting_TermsConditions.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Get_Setting_TermsConditions(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// دریافت ورژن برنامه
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        [AllowAnonymous]
        public async Task<IActionResult> GetVersion([FromBody] Get_VersionSetting.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Get_VersionSetting(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// دریافت تنظیمات مربوط به صفحه پیش فاکتور - سمت مشتری استفاده می شود
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        [AllowAnonymous]
        public async Task<IActionResult> GetSettingCheckOut([FromBody] Get_Setting_Checkout.Inputs inputs, CancellationToken cancellationToken)
        {

            var setting = await _redisService.Get<Get_Setting_Checkout.Outputs>("settingCheckout");
            if (setting == null)
            {
                var rst = await _ctx.Get_Setting_Checkout(new Get_Setting_Checkout.Inputs { }, cancellationToken);
                setting = await _redisService.Set<Get_Setting_Checkout.Outputs>("settingCheckout", rst.Data);
            }

            return Ok(new DBResult(setting, 1));
        }


        /// <summary>
        /// ایجاد یک تنظیم جدید در سیستم
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPost]
        public async Task<IActionResult> Save([FromBody] Insert_Setting.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Insert_Setting(inputs, cancellationToken);
            return Ok(rst);
        }
        [HttpGet]
        public async Task<IActionResult> CallAlanChand(CancellationToken cancellationToken)
        {
            var rst = await _httpRequestCrawler.CallAlanchand(cancellationToken);
            return Ok(rst);
        }
        [HttpGet]
        public async Task<IActionResult> CallNavasan(CancellationToken cancellationToken)
        {
            var rst = await _httpRequestCrawler.CallNavasan(cancellationToken);
            return Ok(rst);
        }
        [HttpGet]
        public async Task<IActionResult> CallBonbast(CancellationToken cancellationToken)
        {
            var rst = await _httpRequestCrawler.CallBonbast(cancellationToken);
            return Ok(rst);
        }
        [HttpGet]
        public async Task<IActionResult> CallXe(CancellationToken cancellationToken)
        {
            var rst = await _httpRequestCrawler.CallXe(cancellationToken);
            return Ok(rst);
        }

        [HttpPut]
        public async Task<IActionResult> CallIssabel([FromBody] HttpRequestIssabelCommand command, CancellationToken cancellationToken)
        {
            var rst = await _httpRequestCrawler.CallIssabel(command, cancellationToken);
            return Ok(rst);
        }
    }
}
