﻿using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Farakonesh.Logic.Database;
using Farakonesh.Logic.IDatabase.idbo;
using Farakonesh.Models.Database.StoredProcedures.App.dbo.shortLink;
using System.Threading;
using System.Threading.Tasks;

namespace Farakonesh.API.Controllers.App.dbo
{
    /// <summary>
    /// سرویس های کار با لینک های کوتاه
    /// </summary>
    [Route("api/[controller]/[action]")]
    [ApiController]
    public class ShortLinkController : ControllerBase
    {
        private readonly IPublicContext _ctx;
        public ShortLinkController(
IPublicContext ctx)
        {
            _ctx = ctx;
        }
        /// <summary>
        /// دریافت اطلاعات کامل لینک کوتاه
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        [AllowAnonymous]
        public async Task<IActionResult> Get([FromBody] Get_ShortLink.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Get_ShortLink(inputs, cancellationToken);
            return Ok(rst);
        }
    }
}
