﻿using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Farakonesh.API.Filters;
using Farakonesh.Logic.Database;
using Farakonesh.Logic.IDatabase;
using Farakonesh.Logic.IDatabase.idbo;
using Farakonesh.Models.Database.StoredProcedures.App.dbo.setting;
using Farakonesh.Models.Database.StoredProcedures.App.dbo.staticData;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading;
using System.Threading.Tasks;

namespace Farakonesh.API.Controllers.App.dbo
{
    /// <summary>
    /// سرویس های کار با مقادیر ثابت سیستم
    /// </summary>
    [Route("api/[controller]/[action]")]
	[ApiController]
	public class StaticController : ControllerBase
	{
        private readonly IStaticContext _ctxStatic;

        public StaticController(IStaticContext ctxStatic)
		{
			_ctxStatic = ctxStatic;
		}
        /// <summary>
        /// دریافت تمامی مقادیر ثابت سیستم
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
		[HttpPut]
		[CustomersAuth]
		public async Task<IActionResult> GetAll([FromBody] GetStatic.Inputs inputs, CancellationToken cancellationToken)
		{
			var rst = await _ctxStatic.GetStatic(inputs, cancellationToken);
			return Ok(rst);
		}
        /// <summary>
        /// دریافت اطلاعات یک مقدار ثابت با شناسه آن
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        [CustomersAuth]
        public async Task<IActionResult> GetById([FromBody] Get_StaticById.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctxStatic.Get_StaticById(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// دریافت تمامی مقادیر ثابت سیستم در سمت ادمین
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> GetByAdmin([FromBody] Get_Static.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctxStatic.Get_Static(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// دریافت مقادیر ثابتی که به عنوان روت و یا اصطلاحا پدر شناخته می شوند
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> GetParentByAdmin([FromBody] Get_Static_Parent.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctxStatic.Get_Static_Parent(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// ثبت یک مقدار ثابت جدید
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPost]
        public async Task<IActionResult> Save([FromBody] Insert_Static.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctxStatic.Insert_Static(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// بروز رسانی یک مقدار ثابت
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> Update([FromBody] Update_Static.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctxStatic.Update_Static(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// حذف یک مقدار ثابت ، (خیلی در استفاده از این سرویس دقت کنید ، حذف یک مقدار ثابت می تواند کارکرد سیستم را دچار اشکال کند)
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpDelete]
        public async Task<IActionResult> Delete([FromQuery] Delete_Static.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctxStatic.Delete_Static(inputs, cancellationToken);
            return Ok(rst);
        }
    }
}
