﻿using Farakonesh.Logic.IDatabase.idbo;
using Farakonesh.Logic.Services.Cache;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using System.Threading.Tasks;
using System.Threading;
using Farakonesh.Models.Database.StoredProcedures.App.dbo.supportPhones;
using Microsoft.AspNetCore.Authorization;
using Farakonesh.Commands.Queue;

namespace Farakonesh.API.Controllers.App.dbo
{
    [Route("api/[controller]/[action]")]
    [ApiController]
    public class SupportPhonesController : ControllerBase
    {
        private readonly ISupportPhonesContext _ctx;

        public SupportPhonesController(ISupportPhonesContext ctx)
        {
            _ctx = ctx;
        }
        /// <summary>
        /// دریافت لیست شماره ها سمت ادمین
        /// </summary>
        /// <param name="inputs"></param>
        /// <param name="cancellationToken"></param>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> GetAllByAdmin([FromBody] Get_SupportPhonesByAdmin.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Get_SupportPhonesByAdmin(inputs,cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// دریافت لیست شماره ها سمت مشتری
        /// </summary>
        /// <param name="cancellationToken"></param>
        /// <returns></returns>
        [HttpGet]
        [AllowAnonymous]
        public async Task<IActionResult> GetAll([FromQuery] Get_SupportPhones.Inputs input,CancellationToken cancellationToken)
        {
            var rst = await _ctx.Get_SupportPhones(input, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// ثبت شماره جدید - سمت ادمین
        /// </summary>
        /// <param name="inputs"></param>
        /// <param name="cancellationToken"></param>
        /// <returns></returns>
        [HttpPost]
        public async Task<IActionResult> Insert([FromBody]Insert_SupportPhones.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Insert_SupportPhones(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// بروز رسانی شماره - سمت ادمین
        /// </summary>
        /// <param name="inputs"></param>
        /// <param name="cancellationToken"></param>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> Update([FromBody] Update_SupportPhones.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Update_SupportPhones(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// حذف شماره - سمت ادمین
        /// </summary>
        /// <param name="inputs"></param>
        /// <param name="cancellationToken"></param>
        /// <returns></returns>
        [HttpDelete]
        public async Task<IActionResult> Delete([FromQuery]Delete_SupportPhones.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Delete_SupportPhones(inputs, cancellationToken);
            return Ok(rst);
        }
    }
}
